% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling.R
\name{place.fossils}
\alias{place.fossils}
\title{Place fossil samples from one tree in another tree, or find the ancestral
node for each fossil sample in one tree.}
\usage{
place.fossils(tree, fossils, ext.tree)
}
\arguments{
\item{tree}{an object of class "Phylo".}

\item{fossils}{an object of class "fossils" that corresponds to fossil
occurrences for the "tree" argument.}

\item{ext.tree}{an object of class "Phylo" representing the extant
counterpart to "tree", this can be obtained with prune.fossil.tips(tree).}
}
\value{
a vector of node numbers corresponding to the direct ancestor of each
  fossil sample in "fossils".
}
\description{
If "ext.tree" is not supplied, this function will find the direct ancestral
node for each of the supplied fossil samples. If "ext.tree" is supplied, this
function will find the direct ancestral node for each fossil in "ext.tree".
This second behaviour is used for placing fossils simulated on a complete
Birth-Death tree in the extant-only counterpart tree. This results in fossil
samples being placed in the crown clades of the tree upon which they were
simulated. When "ext.tree" is supplied, any fossil samples appearing before
the MRCA of the crown group are discarded.
}
\examples{
t = TreeSim::sim.bd.taxa(10, 1, 0.1, 0.05)[[1]]
f = sim.fossils.poisson(0.1, t, root.edge = FALSE)
place.fossils(t,f)
}
