% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2D_functions.R
\name{PC}
\alias{PC}
\title{Principal component (PC) estimation of the approximate factor model}
\usage{
PC(Y, r)
}
\arguments{
\item{Y}{A \eqn{T \times N} data matrix. T = number of time series observations,
N = cross-sectional dimension.}

\item{r}{= the number of factors.}
}
\value{
A list containing the factors and factor loadings:
\itemize{

   \item factor = a \eqn{T \times r} matrix of the estimated factors.

   \item loading = a \eqn{N \times r} matrix of the estimated factor loadings.

}
}
\description{
Perform PC estimation of the (2D) approximate factor model:
\deqn{y_{it}=\boldsymbol{\lambda}_{i}^{\prime}\boldsymbol{F}_{t}+e_{it},}
or in matrix notation:
\deqn{\boldsymbol{Y}=\boldsymbol{F}\boldsymbol{\Lambda}^{\prime}+\boldsymbol{e}.}
The factors \eqn{\boldsymbol{F}} is estimated as \eqn{\sqrt{T}} times the \eqn{r} eigenvectors of
the matrix \eqn{\boldsymbol{Y}\boldsymbol{Y}^{\prime}} corresponding to the \eqn{r}
largest eigenvalues in descending order, and the loading matrix is estimated by
\eqn{\boldsymbol{\Lambda}=T^{-1}\boldsymbol{Y}^{\prime}\boldsymbol{F}}.
See e.g. Bai and Ng (2002).
}
\examples{

# simulate data

T <- 100
N <- 50
r <- 2
F <- matrix(stats::rnorm(T * r, 0, 1), nrow = T)
Lambda <- matrix(stats::rnorm(N * r, 0, 1), nrow = N)
err <- matrix(stats::rnorm(T * N, 0, 1), nrow = T)
Y <- F \%*\% t(Lambda) + err

# estimation

est_PC <- PC(Y, r)
}
\references{
Bai, J. and Ng, S., 2002. Determining the number of factors in approximate factor models.
Econometrica, 70(1), pp.191-221.
}
