% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_GO_child_term_metrics.R
\name{compute_GO_child_term_metrics}
\alias{compute_GO_child_term_metrics}
\title{Retrieve and Plot the Offspring Nodes of GO Terms}
\usage{
compute_GO_child_term_metrics(GO_data, GO_terms, ontology = "BP", plot = FALSE)
}
\arguments{
\item{GO_data}{A list of GO data where each element corresponds to a different feature list.
Each element should have a @result data frame with a column 'ID' containing GO terms.}

\item{GO_terms}{A character vector containing GO term IDs for which offspring nodes are to be fetched.}

\item{ontology}{A character string specifying the type of ontology to be considered.
Can be one of 'BP' (Biological Process), 'MF' (Molecular Function), or 'CC' (Cellular Component).
Default is 'BP'.}

\item{plot}{A logical. If TRUE, the function plots the number and fraction of offspring nodes
for each term in \code{GO_terms} across all feature lists in \code{GO_data}.
Default is FALSE.}
}
\value{
A data frame with columns:
\itemize{
\item \strong{feature_list} - The names of the feature lists from \code{GO_data}.
\item \strong{all_terms_number} - The total number of GO terms in each feature list.
\item \strong{offspring_nodes_number} - The number of offspring nodes for the given GO term(s) in each feature list.
\item \strong{offspring_terms} - The actual offspring terms for the given GO term(s) in each feature list, concatenated by ';'.
\item \strong{fraction} - The fraction (percentage) of offspring nodes out of all terms in each feature list.
\item \strong{GO_term} - The GO term being considered.
}
}
\description{
This function retrieves the children nodes for a set of Gene Ontology (GO) terms
from a list of GO terms and can plot the offspring nodes' numbers and fractions for each term.
}
\examples{
\donttest{
# Mock GO terms data frame
all_selection.GO_inbuilt <- data.frame(
  GO_ID = c("GO:0002376", "GO:0008150", "GO:0006955", "GO:0009628"),
  Description = c("immune system process",
                  "biological_process",
                  "immune response",
                  "response to virus"),
  Parent_GO_ID = c(NA, NA, "GO:0002376", "GO:0006955"), # Simplified parent-child
  stringsAsFactors = FALSE
)

# Mock vector of GO terms to compute metrics for
GO_terms_vec <- c("GO:0002376", "GO:0008150")

# Assuming compute_GO_child_term_metrics is defined and available
# df_res <- compute_GO_child_term_metrics(GO_data = all_selection.GO_inbuilt,
#                                        GO_terms = GO_terms_vec,
#                                        plot = TRUE)
}

}
