% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAnimatedFlowmap.R
\name{plotAnimatedFlowmap}
\alias{plotAnimatedFlowmap}
\title{Generating flow maps and animations based on transition probabilities}
\usage{
plotAnimatedFlowmap(
  hvt_model_output,
  transition_probability_df,
  df,
  animation = "All",
  flow_map = "All",
  fps_time = 1,
  fps_state = 1,
  time_duration = 2,
  state_duration = 2,
  cellid_column,
  time_column
)
}
\arguments{
\item{hvt_model_output}{List. Output from a trainHVT function.}

\item{transition_probability_df}{List. Output from getTransitionProbability function}

\item{df}{Data frame. The input dataframe should contain two columns, 
cell ID from scoreHVT function and time stamp of that dataset.}

\item{animation}{Character. Type of animation ('state_based', 'time_based', 'All' or  NULL)}

\item{flow_map}{Character. Type of flow map ('self_state', 'without_self_state', 'All' or NULL)}

\item{fps_time}{Numeric. A numeric value for the frames per second of the time transition gif.
(Must be a numeric value and a factor of 100). Default value is 1.}

\item{fps_state}{Numeric. A numeric value for the frames per second of the state transition gif.
(Must be a numeric value and a factor of 100). Default value is 1.}

\item{time_duration}{Numeric. A numeric value for the duration of the time transition gif.
Default value is 2.}

\item{state_duration}{Numeric. A numeric value for the duration of the state transition gif.
Default value is 2.}

\item{cellid_column}{Character. Name of the column containing cell IDs.}

\item{time_column}{Character. Name of the column containing time stamps}
}
\value{
A list of flow maps and animation gifs.
}
\description{
This is the main function for generating flow maps and animations based on transition probabilities
including self states and excluding self states.
Flow maps are a type of data visualization used to represent the transition probability of different states. 
Animations are the gifs used to represent the movement of data through the cells.
}
\examples{
dataset <- data.frame(date = as.numeric(time(EuStockMarkets)),
                      DAX = EuStockMarkets[, "DAX"],
                      SMI = EuStockMarkets[, "SMI"],
                      CAC = EuStockMarkets[, "CAC"],
                      FTSE = EuStockMarkets[, "FTSE"])
hvt.results<- trainHVT(dataset,n_cells = 10, depth = 1, quant.err = 0.1,
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method = "kmeans")
scoring <- scoreHVT(dataset, hvt.results)
cell_id <- scoring$scoredPredictedData$Cell.ID
time_stamp <- dataset$date
dataset <- data.frame(cell_id, time_stamp)
table <- getTransitionProbability(dataset, cellid_column = "cell_id",time_column = "time_stamp")
plots <- plotAnimatedFlowmap(hvt_model_output = hvt.results, transition_probability_df = table,
df = dataset, animation = 'All', flow_map = 'All',fps_time = 1,fps_state =  1,time_duration = 2,
state_duration = 2,cellid_column = "cell_id", time_column = "time_stamp")
}
\seealso{
\code{\link{trainHVT}} \cr \code{\link{scoreHVT}} \cr \code{\link{getTransitionProbability}}
}
\author{
PonAnuReka Seenivasan <ponanureka.s@mu-sigma.com>, Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{Timeseries_Analysis}
