% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_network.R
\name{summary_network}
\alias{summary_network}
\title{The summary of the resulting network structures.}
\usage{
summary_network(opt_Mu_hat, opt_Theta_hat, data)
}
\arguments{
\item{opt_Mu_hat}{A p * K0_hat matrix, the optional mean vectors of K0_hat subgroups.}

\item{opt_Theta_hat}{n * p * K0_hat matrix, the optional precision matrices of K0_hat subgroups.}

\item{data}{A n * p matrix, the design matrix.}
}
\value{
A list including the overlap of edges of different subgroups, the number of edges, and the names of connected nodes to each nodes in each subgroup.
}
\description{
Summarize the characteristics of the resulting network structures.
}
\examples{
\donttest{
data(example.data)
K <- 6
lambda <- genelambda.obo(nlambda1=5,lambda1_max=0.5,lambda1_min=0.1,
                         nlambda2=15,lambda2_max=1.5,lambda2_min=0.1,
                         nlambda3=10,lambda3_max=3.5,lambda3_min=0.5)

res <- GGMPF(lambda, example.data$data, K, initial.selection="K-means")
Theta_hat.list <- res$Theta_hat.list
Mu_hat.list <- res$Mu_hat.list
opt_num <- res$Opt_num
opt_Theta_hat <- Theta_hat.list[[opt_num]]
opt_Mu_hat <- Mu_hat.list[[opt_num]]
K_hat <- dim(opt_Theta_hat)[3]
K_hat

summ <- summary_network(opt_Mu_hat, opt_Theta_hat, example.data$data)
summ$Theta_summary$overlap
va_names <- c("1","6")
linked_node_names(summ, va_names, num_subgroup=1)
plot_network(summ, num_subgroup = c(1:K_hat), plot.mfrow = c(1,K_hat))
}

}
