% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MutiMiRNA_CRModel.R
\name{MutiMiRNA_CRModel}
\alias{MutiMiRNA_CRModel}
\title{MutiMiRNA_CRModel}
\usage{
MutiMiRNA_CRModel(ExpData, MiRNAs,SurvivalData,cutoff.point=NULL)
}
\arguments{
\item{ExpData}{A gene expression profile of interest (rows are genes, columns are samples).}

\item{MiRNAs}{An interest miRNA vector.}

\item{SurvivalData}{Survival data (the column names are: "sample", "status", and "time") corresponding to the samples in gene expression profile of interest.}

\item{cutoff.point}{A numeric value used to divide high-risk and low-risk groups.}
}
\value{
A list includes a data frame with seven parts those are "sample", "status", "time", "target gene expression", "risk score", "group", and a data frame with five columns those are "Gene", "HR", "HR.95L", "HR.95H", "beta", and "P-value".
}
\description{
Function "MutiMiRNA_CRModel" can build a multivariate Cox model through integrating the models constructed separately based on different mirna targets.
}
\examples{
# Obtain the example data
GEP<-GetData_Mirna("GEP")
survival<-GetData_Mirna("survival")
MiRNAs<-c("hsa-miR-21-5p","hsa-miR-26a-5p","hsa-miR-369-5p","hsa-miR-1238-3p","hsa-miR-10b-5p")
# Run the function
MutiMiRNA_CRData<-MutiMiRNA_CRModel(GEP,
MiRNAs,survival,cutoff.point=NULL)
}
