% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{get_shapley_values}
\alias{get_shapley_values}
\title{Get the shapley-values of a portfolio of algorithms}
\usage{
get_shapley_values(
  dsList,
  targets,
  scale.log = T,
  group_size = 5,
  max_perm_size = 10,
  normalize = T
)
}
\arguments{
\item{dsList}{The DataSetList object}

\item{targets}{A list or data.table containing the targets per function / dimension. If this is
a data.table, it needs columns 'target', 'DIM' and 'funcId'}

\item{scale.log}{Whether to use logarithmic scaling for the runtimes at which the ecdf will be sampled or not}

\item{group_size}{How many permutation groups will be considered}

\item{max_perm_size}{The maximum limit for permutations to be considered}

\item{normalize}{Whether or not to ensure the resulting values will be in [0,1]}
}
\description{
Based on the contribution to the ECDF-curve of the VBS of the portfolio
}
\examples{
\dontshow{data.table::setDTthreads(1)}
dsl_sub <- subset(dsl, funcId == 1)
get_shapley_values(dsl_sub, get_ECDF_targets(dsl_sub), group_size = 2)
}
