% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA.R
\name{GA}
\alias{GA}
\title{Genetic Algorithm for LHD}
\usage{
GA(n, k, m, N, pmut, p = 15, q = 1)
}
\arguments{
\item{n}{A positive integer.}

\item{k}{A positive integer.}

\item{m}{A positive even integer.}

\item{N}{A positive integer.}

\item{pmut}{A probability.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{GA} returns a maximin distance LHD constructed by genetic algorithm (GA)
}
\details{
\itemize{
\item \code{n} stands for the number of rows (or run size).
\item \code{k} stands for the number of columns (or the number of factors).
\item \code{m} stands for the number of population and it must be an even number.
\item \code{N} stands for the number of iterations.
\item \code{pmut} stands for the probability of mutation.
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
}
}
\examples{
#create a 8 by 3 maximin distance LHD, with # of population and iterations = 10,
#the probability of mutation is 1/(k-1)
tryGA1=GA(n=8,k=3,m=10,N=10,pmut=1/(3-1),p=15,q=1)
tryGA1
phi_p(tryGA1,p=15,q=1)   #calculate the phi_p of "tryGA1".

#Another example with different n and k.
tryGA2=GA(n=12,k=2,m=10,N=10,pmut=1/(3-1),p=15,q=1)
tryGA2
phi_p(tryGA2,p=15,q=1)   #calculate the phi_p of "tryGA2".
}
\references{
Liefvendahl, M., and Stocki, R. (2006) A study on algorithms for optimization of Latin hypercubes. \emph{Journal of Statistical Planning and Inference}, \strong{136}, 3231-3247.
}
