% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLMR_tidy.R
\name{llm_fn}
\alias{llm_fn}
\title{Apply an LLM prompt over vectors/data frames}
\usage{
llm_fn(
  x,
  prompt,
  .config,
  .system_prompt = NULL,
  ...,
  .return = c("text", "columns", "object")
)
}
\arguments{
\item{x}{A character vector \emph{or} a data.frame/tibble.}

\item{prompt}{A glue template string. With a data-frame you may reference
columns (\code{{col}}); with a vector the placeholder is \code{{x}}.}

\item{.config}{An \link{llm_config} object.}

\item{.system_prompt}{Optional system message (character scalar).}

\item{...}{Passed unchanged to \code{\link[=call_llm_broadcast]{call_llm_broadcast()}} (e.g. \code{tries},
\code{progress}, \code{verbose}).}

\item{.return}{One of \code{c("text","columns","object")}. \code{"columns"}
returns a tibble of diagnostic columns; \code{"text"} returns a character
vector; \code{"object"} returns a list of \code{llmr_response} (or \code{NA} on failure).}
}
\value{
For generative mode:
\itemize{
\item \code{.return = "text"}: character vector
\item \code{.return = "columns"}: tibble with diagnostics
\item \code{.return = "object"}: list of \code{llmr_response} (or \code{NA} on failure)
For embedding mode, always a numeric matrix.
}
}
\description{
Apply an LLM prompt over vectors/data frames
}
\examples{
if (interactive()) {
  words <- c("excellent","awful")
  cfg <- llm_config("openai","gpt-4o-mini", temperature = 0)
  llm_fn(words, "Classify '{x}' as Positive/Negative.",
         cfg,
         .system_prompt="One word.",
         .return="columns")
}
}
\seealso{
\code{\link[=llm_mutate]{llm_mutate()}}, \code{\link[=setup_llm_parallel]{setup_llm_parallel()}}, \code{\link[=call_llm_broadcast]{call_llm_broadcast()}}
}
