% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDF.R
\name{CDF}
\alias{CDF}
\alias{onesample.cdf}
\title{Inference on Cumulative Distribution Function}
\description{
Performs statistical inference on population cumulative distribution function.
}
\examples{
pmt("onesample.cdf")$test(Table1.2.1)$plot(style = "graphic")

}
\section{Super classes}{
\code{\link[LearnNonparam:PermuTest]{LearnNonparam::PermuTest}} -> \code{\link[LearnNonparam:OneSampleTest]{LearnNonparam::OneSampleTest}} -> \code{CDF}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CDF-new}{\code{CDF$new()}}
\item \href{#method-CDF-plot}{\code{CDF$plot()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="print"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-print'><code>LearnNonparam::PermuTest$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="LearnNonparam" data-topic="PermuTest" data-id="test"><a href='../../LearnNonparam/html/PermuTest.html#method-PermuTest-test'><code>LearnNonparam::PermuTest$test()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDF-new"></a>}}
\if{latex}{\out{\hypertarget{method-CDF-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{CDF} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDF$new(method = c("binomial", "dkw"), conf_level = 0.95)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{a character string specifying whether to use a confidence band based on the binomial distribution or the Dvoretzky–Kiefer–Wolfowitz inequality.}

\item{\code{conf_level}}{a number specifying confidence level of the confidence bounds.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CDF} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CDF-plot"></a>}}
\if{latex}{\out{\hypertarget{method-CDF-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the estimate and confidence bounds for population cumulative distribution function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CDF$plot(style = c("graphics", "ggplot2"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{a character string specifying which package to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself (invisibly).
}
}
}
