% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{organizeResults}
\alias{organizeResults}
\title{Prepare output for LipidMS annotation functions}
\usage{
organizeResults(
  candidates,
  coelfrags,
  clfrags,
  classConf,
  chainsComb,
  intrules,
  intConf,
  nchains,
  class,
  acquisitionmode
)
}
\arguments{
\item{candidates}{candidates data frame. Output of \link{findCandidates}.}

\item{coelfrags}{list of coeluting fragments for each candidate}

\item{clfrags}{vector containing the expected fragments for a given lipid
class.}

\item{classConf}{output of \link{checkClass}}

\item{chainsComb}{output of \link{combineChains}}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}.}

\item{intConf}{output of \link{checkIntensityRules}}

\item{nchains}{number of chains of the targeted lipid class.}

\item{class}{character value. Lipid class (i.e. PC, PE, DG, TG, etc.).}

\item{acquisitionmode}{acquisition mode (DIA or DDA).}
}
\description{
Prepare a readable output for LipidMS identification functions.
}
\details{
Coelution score for DIA data is calculated as the mean coelution 
score of all fragments used for annotation, while for DDA data, the intensity
score is given, which is calculated as the sum of the relative intensities of 
the fragments used for annotation.
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
