% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_and_translate.R
\name{combine_and_translate}
\alias{combine_and_translate}
\title{Combine data for visualization}
\usage{
combine_and_translate(inputframe, groupframe, itemname, indexname, inputtype)
}
\arguments{
\item{inputframe}{Data frame of index ,sample ID in column,requires all numeric(e.g. result from Alpha_diversity_calculator or Top_taxa function)}

\item{groupframe}{Data frame of group information(and other abiotic/geographic factors)}

\item{itemname}{A character string of your inputframe itemname}

\item{indexname}{A character string of your inputframe indexname}

\item{inputtype}{If sample ID were in row and index in column in inputframe.}
}
\value{
key-value pairs data frame
}
\description{
Combine group information and index into data frame for visualization(scatter, bar plot, alluvial,box plot etc.).
}
\examples{
{
  require(magrittr)
  data(testotu)

  ## Data preparation ##
  Alpha <- Alpha_diversity_calculator2(
    input = testotu,
    prefix = "Bacterial",
    inputformat = 1,
    reads = TRUE
  )

  topotu <- data.frame(
    Top_taxa(
      input = testotu,
      n = 10,
      inputformat = 1,
      outformat = 1
    )[, -1],
    row.names = paste0(rep("otu", 11), 1:11)
  )

  groupinformation1 <- data.frame(
    group = c(rep("a", 10), rep("b", 10)),
    factor1 = rnorm(10),
    factor2 = rnorm(mean = 100, 10)
  )

  ### Use inputtype = FALSE ###
  head(Alpha)
  combine_and_translate(
    Alpha, groupinformation1,
    itemname = "Alpha", indexname = "index",
    inputtype = FALSE
  )

  ### Use inputtype = TRUE ###
  head(topotu)
  combine_and_translate(
    topotu, groupinformation1,
    itemname = "OTU", indexname = "reads",
    inputtype = TRUE
  )
}
}
\author{
Wang Ningqi\href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
