% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnpos.R
\name{bnpos}
\alias{bnpos}
\title{Bayesian analysis of generalised nonlinear mixed model with one random effect}
\usage{
bnpos(m, n, n.chains, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{n.chains}{number of MCMC chains}

\item{data}{dataset with integer entries with missing values. first row represents proportion,size of dataset 
should be 11 by 6. Inside the function we are taking first 6 column of the propdata in this package for the example given.}
}
\value{
posterior distribution result of parameters
}
\description{
Bayesian analysis of generalized nonlinear mixed model where response follows poisson distribution using
MCMC
}
\details{
Here the response variable \eqn{Y_{ij}} has poisson distribution
 mean and variance given one random effect as \eqn{E(Y_{ij}|b_i)=Var(Y_{ij}|b_i)
 } where link function is 
 \deqn{log(E(Y_{ij}|b_i))=\beta_1+b_{1i}+\beta_2 exp(-\beta_{3}x_{ij})}
 where i is the ith subject and j is the timepoint and \eqn{b_i\sim N(0,\sigma_1^2)} are independent.
}
\examples{
 ##
 data(propdata)
 bnpos(m=1,n=3,n.chains=1,data=propdata)
 ##
}
\references{
Broemeling, Lyle D. Bayesian methods for repeated measures. CRC Press, 2015.
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
