% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byrga.R
\name{byrga}
\alias{byrga}
\title{Bayesian analysis of mean response model with autoregressive  covariance
matrix}
\usage{
byrga(m, n, n.chains, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{n.chains}{number of MCMC chains}

\item{data}{dataset whose first row is the respective time points at which observations are taken}
}
\value{
posterior distribution  results of the parameters
}
\description{
Bayesian analysis is performed using MCMC and uses a
linear regression with an autoregressive covariance matrix for the response
}
\details{
The model for the response is \deqn{Y_{ij}=X_{ij}'\beta+e_{ij}}
and \deqn{e_{ij}=\rho e_{ij-1}+u_{ij}} ,\eqn{u_{ij}\sim N(0,1/\tau);\rho} is the correlation
coefficient where i refers to ith individual and j is the timepoint.
}
\examples{
##
data(repeatdata)
byrga(m=1,n=3,n.chains=1,data=repeatdata)
##
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
