coldisc.mle <- function(x, distr = "poisson", N = NULL, type = 1, tol = 1e-7) {
  if ( distr == "poisson" ) {
    res <- Rfast::colpoisson.mle(x)
  } else if ( distr == "geom" ) {
    res <- Rfast::colgeom.mle(x , type = type)
  } else if ( distr == "borel" ) {
    res <- Rfast2::colborel.mle(x)
  } else if ( distr == 'zip' ) {
    res <- .colzip.mle(x, tol = tol)
  } else if ( distr == 'ztp' ) {
    res <- .colztp.mle(x, tol = tol)
  } else if ( distr == 'negbin' ) {
    res <- .colnegbin.mle(x, type = type, tol = tol)
  } else if ( distr == 'binom' ) {
    res <- .colbinom.mle(x, N = N, tol = tol)
  } else if ( distr == 'logseries' ) {
    res <- .collogseries.mle(x, tol = tol)
  } else if ( distr == 'betageom' ) {
    res <- .colbetageom.mle(x, tol = tol)
  } else if ( distr == 'betabinom' ) {
    res <- .colbetabinom.mle(x, N = N, tol = tol)
  } else if ( distr == 'gammapois' ) {
    res <- .colgammapois.mle(x, tol = tol)
  } else if ( distr == 'skellam' ) {
    res <- .colskellam.mle(x)
  } else if ( distr == 'gp' ) {
    res <- .colgp.mle(x)
  } else if ( distr == 'cc' ) {
    res <- .colcc.mle(x)
  } else if ( distr == 'cc0' ) {
    res <- .colcc0.mle(x)
  } else if ( distr == 'com-pois' ) {
    res <- .colcom_pois.mle(x)
  } else if ( distr == "zicom-pois" ) {
    res <- .colzicom_pois.mle(x)
  }
  res
}


#----colzip.mle-----------
.colzip.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast::zip.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'lambda', 'pi')
  res
}

#---colztp.mle-----
.colztp.mle <- function(x, tol) {
  n <- dim(x)[2]
  res<-matrix(nrow = n, ncol = 3)
  for (i in 1:n)  res[i, ] <- unlist( Rfast::ztp.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'lambda')
  res
}

#----colnegbin.mle------
.colnegbin.mle <- function(x, type, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 5)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast::negbin.mle(x[, i], type, tol) )
  colnames(res) <- c('iters', 'loglik', 'success probability', 'number of failures', 'mean')
  res
}

#-----colbinom.mle-----
.colbinom.mle <- function(x, N = NULL, tol) {
  n <- dim(x)[2]
  if ( !is.null(N) ) {
    res <- matrix(nrow = n, ncol = 2)
    for ( i in 1:n )  res[i, ] <- unlist( Rfast::binom.mle(x[, i], N = N[i], tol = tol) )
    colnames(res) <- c("loglik", "probability")
  } else {
    res <- matrix(nrow = n, ncol = 4)
    for ( i in 1:n )  res[i, ] <- unlist( Rfast::binom.mle(x[, i], N = NULL, tol = tol) )
    colnames(res) <- c("iters", "loglik", "Number of trials", "probability")
  }
  res
}

#----collogseries.mle-----
.collogseries.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 3)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast::logseries.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'prob', 'loglik')
  res
}

#-----colbetageom.mle-------
.colbetageom.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast::betageom.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'alpha', 'beta')
  res
}

#----colbetabinom.mle-----
.colbetabinom.mle <- function(x, N, tol = tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast::betabinom.mle(x[, i], N = N[i], tol = tol) )
  colnames(res) <- c('iters', 'alpha', 'beta', 'loglik')
  res
}

#----colgammapois.mle-----
.colgammapois.mle <- function(x, tol) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n )  res[i, ] <- unlist( Rfast2::gammapois.mle(x[, i], tol) )
  colnames(res) <- c('iters', 'loglik', 'shape', 'scale')
  res
}

#----colskellam.mle---
.colskellam.mle <- function(x) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n )  res[i, ] <- unlist( .skellam.mle(x[, i]) )
  colnames(res) <- c('mu1', 'mu2', 'loglik')
  res
}

#---colgp.mle------
.colgp.mle <- function(x) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 3)
  for ( i in 1:n )  res[i, ] <- unlist( gp::gp.mle(x[, i]) )
  colnames(res) <- c('theta', 'lambda', 'loglik')
  res
}

#---collcc.mle-----------
.colcc.mle <- function(x) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 3)
  for ( i in 1:n )  res[i, ] <- unlist( CCd::cc.mle(x[, i]) )
  colnames(res) <- c('mu', 'lambda', 'loglik')
  res
}

#---collcc0.mle-----------
.colcc0.mle <- function(x) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 2)
  for ( i in 1:n )  res[i,] <- unlist( CCd::cc.mle0(x[, i]) )
  colnames(res) <- c('lambda', 'loglik')
  res
}

#---colcom_pois.mle----
.colcom_pois.mle <- function(x) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 3)
  for ( i in 1:n ) {
    a <- COMPoissonReg::glm.cmp(X ~ 1)
    res[i, ] <- c( exp( unlist(a[[ 10 ]]$par) ), a[[ 9 ]] )
  }
  colnames(res) <- c('lambda', 'nu', 'loglik')
  res
}

#---colzicom_pois.mle----
.colzicom_pois.mle <- function(x) {
  n <- dim(x)[2]
  res <- matrix(nrow = n, ncol = 4)
  for ( i in 1:n ) {
    a <- COMPoissonReg::glm.cmp(x ~ 1, formula.p = ~1)
    res[i, ] <- c( exp( unlist(a[[ 12 ]]$par) ), a[[ 11 ]] )
  }
  colnames(res)<-c('lambda', 'nu', 'p', 'loglikelihood')
  res
}
