% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_sobol_jansen_results}
\alias{table_sobol_jansen_results}
\title{Sobol-Jansen Results Table}
\usage{
table_sobol_jansen_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'sensitivity_analysis(methods = "Sobol_Jansen")'.}

\item{show_table}{Boolean. Whether to show the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with Sobol-Jansen results.
}
\description{
The \strong{table_sobol_jansen_results()} function processes results from Sobol-Jansen global sensitivity analysis,
a variance decomposition-based methodology that quantifies each variable's contribution and their interactions
to the total variability of model predictions. This technique is particularly valuable for identifying
higher-order effects and complex interactions between variables.
}
\examples{
# Note: For obtaining the table with Sobol_Jansen method results
# the user needs to complete till sensitivity_analysis() function of the
# MLwrap pipeline using the Sobol_Jansen method.
# Sobol_Jansen method only works when all input features are continuous.

\donttest{

wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
wrap_object <- build_model(wrap_object, "Random Forest")
wrap_object <- fine_tuning(wrap_object, "Bayesian Optimization")
wrap_object <- sensitivity_analysis(wrap_object, methods = "Sobol_Jansen")

# And then, you can obtain the Sobol_Jansen results table.

table_Sobol <- table_sobol_jansen_results(wrap_object)

}

}
