% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_shap}
\alias{plot_shap}
\title{Plotting SHAP Plots}
\usage{
plot_shap(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'sensitivity_analysis(methods = "SHAP")'.}

\item{show_table}{Boolean. Whether to print SHAP summarized results table.}
}
\value{
analysis_object
}
\description{
The \strong{plot_shap()} function implements comprehensive SHAP (SHapley Additive
exPlanations) value visualizations where SHAP values represent each
feature's marginal contribution to model output based on cooperative game
theory principles. Provides four visualization modalities: bar plots of mean
absolute SHAP values ranking features by average impact magnitude,
directional plots showing feature-value correlation with SHAP magnitude and
sign, box plots illustrating SHAP value distributions across instances, and
swarm plots combining individual prediction contributions with
distributional information.
}
\examples{
# Note: For obtaining the SHAP plots the user needs to complete till
# sensitivity_analysis( ) function of the MLwrap pipeline using the SHAP
# method.
# See the full pipeline example under sensitivity_analysis()
# (Requires sensitivity_analysis(methods = "SHAP"))
# Final call signature:
# plot_shap(wrap_object)
}
\seealso{
\code{\link{sensitivity_analysis}}
}
