% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_known}
\alias{mcee_config_known}
\title{Configure known constant values for MCEE nuisance parameters}
\usage{
mcee_config_known(target, value = NULL, a1 = NULL, a0 = NULL)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{value}{Numeric scalar. Single constant value for all observations.}

\item{a1, a0}{Numeric scalars. Arm-specific constants for A=1 and A=0 conditions.
If provided, these override \code{value}.}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration for nuisance parameters with known constant values,
bypassing model fitting. Useful for known randomization probabilities in MRTs.
}
\examples{
# Known randomization probability
cfg_p <- mcee_config_known("p", 0.6)

# Arm-specific known values
cfg_eta <- mcee_config_known("eta", a1 = 0.8, a0 = 0.2)
}
