% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mexico_population.R
\name{get_mexico_population}
\alias{get_mexico_population}
\title{Get Mexico's Population (Total) from World Bank}
\usage{
get_mexico_population()
}
\value{
A tibble with the following columns:
\describe{
  \item{indicator}{Indicator name (e.g., "Population, total")}
  \item{country}{Country name ("Mexico")}
  \item{year}{Year of the data (integer)}
  \item{value}{Population as numeric value}
  \item{value_label}{Formatted population value (e.g., "126,705,138")}
}
}
\description{
Retrieves Mexico's total population for the years 2010 to 2022
using the World Bank Open Data API. The indicator used is `SP.POP.TOTL`.
}
\details{
The function sends a GET request to the World Bank API. If the request fails
or returns an error code, it will return `NULL` with an informative message.
}
\note{
Requires internet connection. Data is retrieved in real time from the World Bank API.
}
\examples{
if (interactive()) {
  get_mexico_population()
}

}
\seealso{
\link[httr]{GET}, \link[jsonlite]{fromJSON}, \link[dplyr]{as_tibble}, \link[scales]{comma}
}
