% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targets_misc.R
\name{list_fastq_files}
\alias{list_fastq_files}
\title{List fastq files}
\usage{
list_fastq_files(
  path,
  paired_end = TRUE,
  pattern = "fastq",
  pattern_R1 = "_R1_",
  pattern_R2 = "_R2_",
  nb_files = Inf
)
}
\arguments{
\item{path}{path to files (required)}

\item{paired_end}{do you have paired_end files? (default TRUE)}

\item{pattern}{a pattern to filter files (passed on to list.files function).}

\item{pattern_R1}{a pattern to filter R1 files (default "\emph{R1}")}

\item{pattern_R2}{a pattern to filter R2 files (default "\emph{R2}")}

\item{nb_files}{the number of fastq files to list (default FALSE)}
}
\value{
a list of one (single end) or two (paired end) list of files
files are sorted by names (default behavior of \code{list.files()})
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Useful for targets bioinformatic pipeline.
}
\examples{
list_fastq_files(system.file("extdata", package = "MiscMetabar"))
list_fastq_files(system.file("extdata", package = "MiscMetabar"),
  paired_end = FALSE, pattern_R1 = ""
)

}
\author{
Adrien Taudière
}
