% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsearch.R
\name{swarm_clustering}
\alias{swarm_clustering}
\title{Re-cluster sequences of an object of class \code{physeq}
or cluster a list of DNA sequences using SWARM}
\usage{
swarm_clustering(
  physeq = NULL,
  dna_seq = NULL,
  d = 1,
  swarmpath = "swarm",
  vsearch_path = "vsearch",
  nproc = 1,
  swarm_args = "--fastidious",
  tax_adjust = 0,
  keep_temporary_files = FALSE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{dna_seq}{NOT WORKING FOR THE MOMENT
You may directly use a character vector of DNA sequences
in place of physeq args. When physeq is set, dna sequences take the value of
\code{physeq@refseq}}

\item{d}{(default: 1) maximum number of differences allowed between two
amplicons, meaning that two amplicons will be grouped if they have \code{d}
(or less) differences}

\item{swarmpath}{(default: swarm) path to swarm}

\item{vsearch_path}{(default: vsearch) path to vsearch, used only if physeq
is NULL and dna_seq is provided.}

\item{nproc}{(default: 1)
Set to number of cpus/processors to use for the clustering}

\item{swarm_args}{(default : "--fastidious") a one length character
element defining other parameters to  passed on to swarm See other possible
methods in the \href{https://github.com/torognes/swarm/blob/master/man/swarm_manual.pdf}{SWARM pdf manual}}

\item{tax_adjust}{(Default 0) See the man page
of \code{\link[=merge_taxa_vec]{merge_taxa_vec()}} for more details.
To conserved the taxonomic rank of the most abundant ASV,}

\item{keep_temporary_files}{(logical, default: FALSE) Do we keep temporary
files ?
\itemize{
\item temp.fasta (refseq in fasta or dna_seq sequences)
\item temp_output (classical output of SWARM)
\item temp_uclust (clusters output of SWARM)
}}
}
\value{
A new object of class \code{physeq} or a list of cluster if dna_seq
args was used.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


A wrapper of SWARM software.
}
\details{
This function use the \code{merge_taxa_vec} function to
merge taxa into clusters. By default tax_adjust = 0. See the man page
of \code{\link[=merge_taxa_vec]{merge_taxa_vec()}}.

This function is mainly a wrapper of the work of others.
Please cite \href{https://github.com/torognes/swarm}{SWARM}.
}
\examples{
\dontshow{if (MiscMetabar::is_swarm_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
summary_plot_pq(data_fungi)
system2("swarm", "-h")

data_fungi_swarm <- swarm_clustering(data_fungi)
summary_plot_pq(data_fungi_swarm)

sequences_ex <- c(
  "TACCTATGTTGCCTTGGCGGCTAAACCTACCCGGGATTTGATGGGGCGAATTAATAACGAATTCATTGAATCA",
  "TACCTATGTTGCCTTGGCGGCTAAACCTACCCGGGATTTGATGGGGCGAATTACCTGGTAAGGCCCACTT",
  "TACCTATGTTGCCTTGGCGGCTAAACCTACCCGGGATTTGATGGGGCGAATTACCTGGTAGAGGTG",
  "TACCTATGTTGCCTTGGCGGCTAAACCTACC",
  "CGGGATTTGATGGCGAATTACCTGGTATTTTAGCCCACTTACCCGGTACCATGAGGTG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACCTGG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACAAAG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACAAAG",
  "GCGGCTAAACCTACCCGGGATTTGATGGCGAATTACAAAG"
)

sequences_ex_swarm <- swarm_clustering(
  dna_seq = sequences_ex
)
\dontshow{\}) # examplesIf}
}
\references{
SWARM can be downloaded from
\url{https://github.com/torognes/swarm/}.

SWARM can be downloaded from
\url{https://github.com/torognes/swarm}.
More information in the associated publications
\doi{doi:10.1093/bioinformatics/btab493} and \doi{doi:10.7717/peerj.593}
}
\seealso{
\code{\link[=postcluster_pq]{postcluster_pq()}}, \code{\link[=vsearch_clustering]{vsearch_clustering()}}
}
