% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/motbf.R
\name{as.function.motbf}
\alias{as.function.motbf}
\title{Coerce an \code{"motbf"} Object to a Function}
\usage{
\method{as.function}{motbf}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"motbf"}.}

\item{...}{Further arguments to be passed to or from the method. Not necessary for this method.}
}
\value{
It returns a function to evaluate an object of class \code{"motbf"}.
}
\description{
Takes an \code{"motbf"} object and contructs an \R function to evaluate it at points.
}
\details{
This is an \code{S3} method for the generic function \link{as.function}.
}
\examples{
## Data
X <- rchisq(5000, df = 3)

## Learning
P <- univMoTBF(X, POTENTIAL_TYPE = "MOP"); P

## Evaluation
as.function(P)(min(X))
as.function(P)(max(X))
as.function(P)(10)
density <- as.function(P)(X)

## Plot
hist(X, prob = TRUE, main = "")
points(X, density, col=4, pch=16)
}

