% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional.R
\name{plotConditional}
\alias{plotConditional}
\title{Plot Conditional Functions}
\usage{
plotConditional(
  conditionalFunction,
  data,
  nameChild = NULL,
  points = FALSE,
  color = NULL,
  ...
)
}
\arguments{
\item{conditionalFunction}{the output of function \link{conditionalMethod}. 
A list containing the the interval of the parent and the final conditional density (MTE or MOP).}

\item{data}{An object of class \code{data.frame}, corresponding to the dataset used to fit the conditional density.}

\item{nameChild}{A \code{character} string, corresponding to the name of the child variable in the conditional density. By default, it is \code{NULL}.}

\item{points}{A logical value. If \code{TRUE}, the sample points are overlaid.}

\item{color}{If not specified, a default palette is used.}

\item{...}{Additional graphical parameters passed to filled.contour().}
}
\value{
A plot of the conditional density function.
}
\description{
Plot conditional MoTBF densities.
}
\details{
If the number of parents is greater than one, then the error message 
"It is not possible to plot the conditional function." is reported.
}
\examples{
## Data
X <- rnorm(1000)
Y <- rnorm(1000, mean=X)
data <- data.frame(X=X,Y=Y)
cov(data)

## Conditional Learning
parent <- "X"
child <- "Y"
intervals <- 5
potential <- "MTE"
P <- conditionalMethod(data, nameParents=parent, nameChild=child, 
numIntervals=intervals, POTENTIAL_TYPE=potential)
plotConditional(conditionalFunction=P, data=data)
plotConditional(conditionalFunction=P, data=data, points=TRUE)

}
\seealso{
\link{conditionalMethod}
}
