% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEdensity.R
\name{Get_r0}
\alias{Get_r0}
\title{Compute long-run risk neutral mean (r0) for the various models}
\usage{
Get_r0(Y, P, N, mat, dt, B_list, Wpca, We, Economies, ModelType)
}
\arguments{
\item{Y}{matrix of yields used in estimation (J x T or CJ x T)}

\item{P}{complete set of spanned factors (N x T or CN x T)}

\item{N}{number of country-specific spanned factors}

\item{mat}{vector of maturities (in years) of yields used in estimation (J x 1)}

\item{dt}{time interval unit of the model (scalar). For instance, if data is (i) monthly, dt <- 12; (ii) quarterly, dt <- 4; (iii) yearly, dt <- 1.}

\item{B_list}{list containing the B loadings}

\item{Wpca}{matrix of weights of the portfolios observed without errors (N x J or CN x J)}

\item{We}{matrix of weights of the portfolios observed with errors ((J-N) x J or C(J-N) x CJ)}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{string-vector containing the label of the model to be estimated}
}
\description{
Compute long-run risk neutral mean (r0) for the various models
}
\keyword{internal}
