% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOutputs.R
\name{InputsForOutputs}
\alias{InputsForOutputs}
\title{Collects the inputs that are used to construct the numerical and graphical outputs}
\usage{
InputsForOutputs(
  ModelType,
  Horiz,
  ListOutputWished,
  OutputLabel,
  WishStationarityQ,
  DataFrequency,
  WishGraphYields = FALSE,
  WishGraphRiskFactors = FALSE,
  WishOrthoJLLgraphs = FALSE,
  WishForwardPremia = FALSE,
  LimFP = NULL,
  WishBootstrap = FALSE,
  ListBoot = NULL,
  WishForecast = FALSE,
  ListForecast = NULL,
  UnitYields = "Month"
)
}
\arguments{
\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{Horiz}{numeric scalar. Desired analysis horizon for the outputs.}

\item{ListOutputWished}{character vector. Desired graphical outputs. Available options: "RiskFactors", "Fit", "IRF", "FEVD", "GIRF", "GFEVD", "TermPremia", "ForwardPremia".}

\item{OutputLabel}{character. Name of the output label to be stored.}

\item{WishStationarityQ}{logical. Whether to impose that the largest eigenvalue under Q is strictly smaller than 1. TRUE to impose.}

\item{DataFrequency}{character. Data frequency. Permissible choices: "Daily All Days", "Daily Business Days", "Weekly", "Monthly", "Quarterly", "Annually".}

\item{WishGraphYields}{logical. Whether to generate graphs for yields. Default is FALSE.}

\item{WishGraphRiskFactors}{logical. Whether to generate graphs for risk factors. Default is FALSE.}

\item{WishOrthoJLLgraphs}{logical. Whether to generate orthogonalized JLL-based graphs. Default is FALSE.}

\item{WishForwardPremia}{logical. Whether to generate forward premia graphs. Default is FALSE.}

\item{LimFP}{numeric vector. Maturities associated with the start and end dates of the loan.}

\item{WishBootstrap}{logical. Whether to perform bootstrap-based estimation. Default is FALSE.}

\item{ListBoot}{list. Contains bootstrap settings: methodBS ("bs", "wild", "block"), BlockLength (numeric), ndraws (numeric), pctg (numeric).}

\item{WishForecast}{logical. Whether to generate forecasts. Default is FALSE.}

\item{ListForecast}{list. Contains forecast settings: ForHoriz (numeric), t0Sample (numeric), t0Forecast (numeric), ForType ("Rolling", "Expanding").}

\item{UnitYields}{character. Maturity unit of yields. Options: "Month" or "Year". Default is "Month".}
}
\value{
List of necessary inputs to generate the graphs and outputs of the desired model.
}
\description{
Collects the inputs that are used to construct the numerical and graphical outputs
}
\examples{

ModelType <- "JPS original"
Horiz <- 100
DesiredOutputGraphs <- c("Fit", "GIRF", "GFEVD")
OutputLabel <- "Test"
WishStationarityQ <- TRUE
WishGraphRiskFac <- FALSE
WishGraphYields <- TRUE

InputsList <- InputsForOutputs(
  ModelType, Horiz, DesiredOutputGraphs, OutputLabel,
  WishStationarityQ, WishGraphYields, WishGraphRiskFac
)

}
