% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimization.R
\name{Optimization_PE}
\alias{Optimization_PE}
\title{Perform the minimization of ML function}
\usage{
Optimization_PE(
  ML_fun,
  ListInputSet,
  FactorLabels,
  Economies,
  ModelType,
  JLLinputs = NULL,
  GVARinputs = NULL,
  tol = 1e-04,
  EstType,
  TimeCount = TRUE,
  verbose
)
}
\arguments{
\item{ML_fun}{vector-valued objective ML function}

\item{ListInputSet}{list containing :
 \enumerate{
     \item a starting value for K1XQ and/or SSZ
     \item a variable label among the following:
               \itemize{
                   \item 'Jordan' or 'Jordan; stationary' for single countries setups or
                   'Jordan MultiCountry' or 'Jordan MultiCountry; stationary'.  All cases related to the computation of a K1XQ parameter;
                   \item 'psd': PSD matrix, used for JPS-based models. It relates to the SSZ parameter;
                   \item  'BlockDiag': block diagonal matrix, used for JPS-based models. It relates to the SSZ parameter.
                   \item 'JLLstructure': to impose the zero-restrictions on the SSZ term along
                           the lines of the JLL models
                       }
}}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{JLLinputs}{List. Inputs for JLL model estimation (see \code{\link{JLL}}). Default is NULL.}

\item{GVARinputs}{List. Inputs for GVAR model estimation (see \code{\link{GVAR}}). Default is NULL.}

\item{tol}{convergence tolerance (scalar). Default value is 1e-4.}

\item{EstType}{Available options are"BFGS" and/or "Nelder-Mead".}

\item{TimeCount}{computes the required time for estimation of the model. Default is TRUE.}

\item{verbose}{Logical flag controlling function messaging.}
}
\description{
Perform the minimization of ML function
}
\keyword{internal}
