% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbd_prob.R
\name{bbd_prob}
\alias{bbd_prob}
\title{Transition probabilities of a birth/birth-death process}
\usage{
bbd_prob(t, a0, b0, lambda1, lambda2, mu2, gamma, A, B, nblocks = 256,
  tol = 1e-12, computeMode = 0, nThreads = 4, maxdepth = 400)
}
\arguments{
\item{t}{time}

\item{a0}{total number of type 1 particles at \code{t = 0}}

\item{b0}{total number of type 2 particles at \code{t = 0}}

\item{lambda1}{birth rate of type 1 particles (a two variables function)}

\item{lambda2}{birth rate of type 2 particles (a two variables function)}

\item{mu2}{death rate function of type 2 particles (a two variables function)}

\item{gamma}{transition rate from type 2 particles to type 1 particles (a two variables function)}

\item{A}{upper bound for the total number of type 1 particles}

\item{B}{upper bound for the total number of type 2 particles}

\item{nblocks}{number of blocks}

\item{tol}{tolerance}

\item{computeMode}{computation mode}

\item{nThreads}{number of threads}

\item{maxdepth}{maximum number of iterations for Lentz algorithm}
}
\value{
a matrix of the transition probabilities
}
\description{
Computes the transition pobabilities of a birth/birth-death process 
using the continued fraction representation of its Laplace transform
}
\examples{
\dontrun{
data(Eyam)

# (R, I) in the SIR model forms a birth/birth-death process

loglik_sir <- function(param, data) {
  alpha <- exp(param[1]) # Rates must be non-negative
  beta  <- exp(param[2])
  N <- data$S[1] + data$I[1] + data$R[1]
  
  # Set-up SIR model with (R, I)
  
  brates1 <- function(a, b) { 0 }
  brates2 <- function(a, b) { beta  * max(N - a - b, 0)  * b }
  drates2 <- function(a, b) { 0 }
  trans21 <- function(a, b) { alpha * b }
  
  sum(sapply(1:(nrow(data) - 1), # Sum across all time steps k
             function(k) {
               log(
                 bbd_prob( # Compute the transition probability matrix
                   t  = data$time[k + 1] - data$time[k], # Time increment
                   a0 = data$R[k], b0 = data$I[k],       # From: R(t_k), I(t_k)
                   brates1, brates2, drates2, trans21,
                   A = data$R[k + 1], B = data$R[k + 1] + data$I[k] - data$R[k],
                   computeMode = 4, nblocks = 80         # Compute using 4 threads
                 )[data$R[k + 1] - data$R[k] + 1, 
                   data$I[k + 1] + 1]                    # To: R(t_(k+1)), I(t_(k+1))
               )
             }))
}

loglik_sir(log(c(3.204, 0.019)), Eyam) # Evaluate at mode
}
}
\references{
Ho LST et al. 2015. "Birth(death)/birth-death processes and their computable transition probabilities with statistical applications". In review.
}

