% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPT.R
\name{NPT}
\alias{NPT}
\title{Perform nested principal component analysis (PCA of PCAs) for ecological niche periodicity}
\usage{
NPT(data, dimension)
}
\arguments{
\item{data}{A data frame containing species trait data.}

\item{dimension}{A list of character vectors, each representing a trait dimension
with corresponding column names from the data.}
}
\value{
A list containing three elements:
\item{PCA_first}{A data frame summarizing the first-level PCA results for each dimension}
\item{PCA_second}{A matrix of species scores from the second-level PCA}
\item{result}{The complete rda object from the second-level PCA}
}
\description{
This function conducts a ‘PCA of PCAs’ to analyze
ecological niche periodicity based on multiple trait dimensions.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks and cleans input data, removing rows with NA values
\item Conducts first-level PCA for each trait dimension
\item Extracts PC1 and PC2 scores from each first-level PCA
\item Combines all PC scores and performs a second-level PCA
\item Returns summary statistics and results from both levels of analysis
}
}
\examples{
data(PFF)
PFF[,3:20] <- log(PFF[,3:20])
traits_dimension <- list(
  grow = c("SLA","Leaf_area","LDMC","SRL","Leaf_Nmass","Leaf_Pmass","Root_Nmass"),
  survive = c("Height","Leaf_Cmass","Root_Cmass","Leaf_CN","Leaf_NP","Leaf_CP","Root_CN"),
  reproductive = c("SeedMass","FltDate","FltDur")
)
result <- NPT(data = PFF, dimension = traits_dimension)
result

}
\references{
\enumerate{
\item Winemiller, K. O., Fitzgerald, D. B., Bower, L. M., & Pianka, E. R. (2015). Functional traits, convergent evolution, and periodic tables of niches. Ecology letters, 18(8), 737-751. https://doi.org/10.1111/ele.12462
\item Yu, R., Huang, J., Xu, Y., Ding, Y., & Zang, R. (2020). Plant functional niches in forests across four climatic zones: Exploring the periodic table of niches based on plant functional traits. Frontiers in Plant Science, 11, 841. https://doi.org/10.3389/fpls.2020.00841
}
}
