% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC_ADSM.R
\name{SPC_ADSM}
\alias{SPC_ADSM}
\title{SPC_DSM}
\usage{
SPC_ADSM(specdat, withBC = TRUE)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data}

\item{withBC}{A logical parameter that enables/disables baseline correction after baseline correction}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
A single linear model with absolute dispersion summation minimization.
}
\details{
This function is to process phase error correction through a single linear model with absolute dispersion summation minimization,
followed by polynomial baseline correction if necessary
}
\examples{
data("fdat")
spc_dsm_phased1 <- SPC_ADSM(fdat$frequency_domain)
}
\references{
Jiang, A. (2024). Phase Error Correction in Magnetic Resonance: A Review of Models, Optimization Functions, and Optimizers in Traditional Statistics and Neural Networks. Preprints. https://doi.org/10.20944/preprints202409.2252.v1

Chen, L., Weng, Z., Goh, L., & Garland, M. (2002). An efficient algorithm for automatic phase correction of NMR spectra based on
entropy minimization. Journal of Magnetic Resonance, 158, 1-2.

Ernst, R. R. (1969). Numerical Hilbert transform and automatic phase correction in magnetic resonance spectroscopy.
Journal of Magnetic Resonance, 1, 7-26
Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
