% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMscanTables.R
\name{NMscanTables}
\alias{NMscanTables}
\title{Find and read all output data tables in Nonmem run}
\usage{
NMscanTables(
  file,
  as.fun,
  quiet,
  col.nmrep = TRUE,
  col.tableno = FALSE,
  col.id = "ID",
  col.row,
  details,
  skip.absent = FALSE,
  meta.only = FALSE,
  modelname,
  col.model
)
}
\arguments{
\item{file}{the Nonmem file to read (normally .mod or .lst)}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say tibble::as_tibble) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}

\item{quiet}{The default is to give some information along the way
on what data is found. But consider setting this to TRUE for
non-interactive use. Default can be configured using
NMdataConf.}

\item{col.nmrep}{col.nmrep If tables are repeated, include a
counter? It does not relate to the order of the $TABLE
statements but to cases where a $TABLE statement is run
repeatedly. E.g., in combination with the SUBPROBLEMS feature
in Nonmem, it is useful to keep track of the table
(repetition) number. If col.nmrep is TRUE, this will be
carried forward and added as a column called NMREP. This is
default behavior when more than one $TABLE repetition is found
in data. Set it to a different string to request the column
with a different name. The argument is passed to NMscanTables.}

\item{col.tableno}{Nonmem includes a counter of tables in the
written data files. These are often not useful. However, if
col.tableno is TRUE (not default), this will be carried
forward and added as a column called NMREP. Even if NMREP is
generated by NMscanTables, it is treated like any other table
column in meta (?NMinfo) data.}

\item{col.id}{name of the subject ID column. Used for calculation
of the number of subjects in each table.}

\item{col.row}{The name of the row counter column. Optional and
only used to check whether the row counter is in the data.}

\item{details}{If TRUE, metadata is added to output. In this case,
you get a list. Typically, this is mostly useful if
programming up functions which behavior must depend on
properties of the output.}

\item{skip.absent}{Skip missing output table files with a warning?
Default is FALSE in which case an error is thrown.}

\item{meta.only}{If TRUE, tables are not read, only a table is
returned showing what tables were found and some available
meta information. Notice, not all meta information (e.g.,
dimensions) are available because the tables need to be read
to derive that.}

\item{modelname}{Only affects meta data table. The model name to
be stored if col.model is not NULL. If not supplied, the name
will be taken from the control stream file name by omitting
the directory/path and deleting the .lst extension
(path/run001.lst becomes run001). This can be a character
string or a function which is called on the value of file
(file is another argument to NMscanData). The function must
take one character argument and return another character
string. As example, see NMdataConf()$modelname. The default
can be configured using NMdataConf.}

\item{col.model}{Only affects meta data table. A column of this
name containing the model name will be included in the
returned data. The default is to store this in a column called
"model". See argument "modelname" as well. Set to NULL if not
wanted. Default can be configured using NMdataConf.}
}
\value{
A list of all the tables as data.frames. If details=TRUE,
    this is in one element, called data, and meta is another
    element. If not, only the data is returned.
}
\description{
Find and read all output data tables in Nonmem run
}
\examples{
tabs1 <- NMscanTables(system.file("examples/nonmem/xgxr001.lst", package="NMdata"))
}
\seealso{
Other DataRead: 
\code{\link{NMreadCsv}()},
\code{\link{NMreadTab}()},
\code{\link{NMscanData}()},
\code{\link{NMscanInput}()}
}
\concept{DataRead}
