# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

sd_dom_matrix_prefix_parallel <- function(X, degree, type = "discrete") {
    .Call(`_NNS_sd_dom_matrix_prefix_parallel`, X, degree, type)
}

NNS_SD_efficient_set_parallel_cpp <- function(X, degree, type = "discrete", status = TRUE) {
    .Call(`_NNS_NNS_SD_efficient_set_parallel_cpp`, X, degree, type, status)
}

NNS_FSD_uni_cpp <- function(x, y, type = "discrete") {
    .Call(`_NNS_NNS_FSD_uni_cpp`, x, y, type)
}

NNS_SSD_uni_cpp <- function(x, y) {
    .Call(`_NNS_NNS_SSD_uni_cpp`, x, y)
}

NNS_TSD_uni_cpp <- function(x, y) {
    .Call(`_NNS_NNS_TSD_uni_cpp`, x, y)
}

NNS_gravity_cpp <- function(xSEXP, discrete = FALSE) {
    .Call(`_NNS_NNS_gravity_cpp`, xSEXP, discrete)
}

NNS_rescale_cpp <- function(xSEXP, a, b, method = "minmax", T_ = NULL, type = "Terminal") {
    .Call(`_NNS_NNS_rescale_cpp`, xSEXP, a, b, method, T_, type)
}

NNS_mode_cpp <- function(xSEXP, discrete = FALSE, multi = TRUE) {
    .Call(`_NNS_NNS_mode_cpp`, xSEXP, discrete, multi)
}

fast_lm <- function(x, y) {
    .Call(`_NNS_fast_lm`, x, y)
}

fast_lm_mult <- function(x, y) {
    .Call(`_NNS_fast_lm_mult`, x, y)
}

LPM_CPv <- function(degree, target, variable) {
    .Call(`_NNS_LPM_CPv`, degree, target, variable)
}

UPM_CPv <- function(degree, target, variable) {
    .Call(`_NNS_UPM_CPv`, degree, target, variable)
}

CoLPM_nD_RCPP <- function(data, target, degree, norm = TRUE) {
    .Call(`_NNS_CoLPM_nD_RCPP`, data, target, degree, norm)
}

CoUPM_nD_RCPP <- function(data, target, degree, norm = TRUE) {
    .Call(`_NNS_CoUPM_nD_RCPP`, data, target, degree, norm)
}

DPM_nD_RCPP <- function(data, target, degree, norm = TRUE) {
    .Call(`_NNS_DPM_nD_RCPP`, data, target, degree, norm)
}

LPM_RCPP <- function(degree, target, variable, excess_ret) {
    .Call(`_NNS_LPM_RCPP`, degree, target, variable, excess_ret)
}

UPM_RCPP <- function(degree, target, variable, excess_ret) {
    .Call(`_NNS_UPM_RCPP`, degree, target, variable, excess_ret)
}

#' @name LPM.ratio
#' @title Lower Partial Moment Ratio
#' @description
#'   This function generates a standardized univariate lower partial moment
#'   of any non‑negative degree for a given target.
#' @param degree numeric; degree = 0 gives frequency (CDF), degree = 1 gives area.
#' @param target numeric vector; threshold(s). Defaults to mean(variable).
#' @param variable numeric vector or data‑frame column to evaluate.
#' @return Numeric vector of standardized lower partial moments.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @references
#'   Viole, F. (2017) Continuous CDFs and ANOVA with NNS. \doi{10.2139/ssrn.3007373}
#' @examples
#'   set.seed(123)
#'   x <- rnorm(100)
#'   LPM.ratio(0, mean(x), x)
#' \dontrun{
#'   plot(sort(x), LPM.ratio(0, sort(x), x))
#'   plot(sort(x), LPM.ratio(1, sort(x), x))
#' }
#' @export
LPM.ratio <- function(degree, target, variable) {
    .Call(`_NNS_LPM_ratio_RCPP`, degree, target, variable)
}

#' @name UPM.ratio
#' @title Upper Partial Moment Ratio
#' @description
#'   This function generates a standardized univariate upper partial moment
#'   of any non‑negative degree for a given target.
#' @param degree numeric; degree = 0 gives frequency, degree = 1 gives area.
#' @param target numeric vector; threshold(s). Defaults to mean(variable).
#' @param variable numeric vector or data‑frame column to evaluate.
#' @return Numeric vector of standardized upper partial moments.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @examples
#'   set.seed(123)
#'   x <- rnorm(100)
#'   UPM.ratio(0, mean(x), x)
#' \dontrun{
#'   plot3d(x, y, Co.UPM(0, sort(x), sort(y), x, y), …)
#' }
#' @export
UPM.ratio <- function(degree, target, variable) {
    .Call(`_NNS_UPM_ratio_RCPP`, degree, target, variable)
}

#' @name Co.LPM
#' @title Co‑Lower Partial Moment
#' @description
#'   Computes the co‑lower partial moment (lower‑left quadrant 4) between two
#'   equal‑length numeric vectors at any degree and target.
#' @param degree_lpm numeric; degree = 0 gives frequency, degree = 1 gives area.
#' @param x numeric vector of observations.
#' @param y numeric vector of the same length as x.
#' @param target_x numeric vector; thresholds for x (defaults to mean(x)).
#' @param target_y numeric vector; thresholds for y (defaults to mean(y)).
#' @return Numeric vector of co‑LPM values.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @examples
#'   set.seed(123)
#'   x <- rnorm(100); y <- rnorm(100)
#'   Co.LPM(0, x, y, mean(x), mean(y))
#' @export
Co.LPM <- function(degree_lpm, x, y, target_x, target_y) {
    .Call(`_NNS_CoLPM_RCPP`, degree_lpm, x, y, target_x, target_y)
}

#' @name Co.UPM
#' @title Co‑Upper Partial Moment
#' @description
#'   Computes the co‑upper partial moment (upper‑right quadrant 1) between two
#'   equal‑length numeric vectors at any degree and target.
#' @param degree_upm numeric; degree = 0 gives frequency, degree = 1 gives area.
#' @param x numeric vector of observations.
#' @param y numeric vector of the same length as x.
#' @param target_x numeric vector; thresholds for x (defaults to mean(x)).
#' @param target_y numeric vector; thresholds for y (defaults to mean(y)).
#' @return Numeric vector of co‑UPM values.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @examples
#'   set.seed(123)
#'   x <- rnorm(100); y <- rnorm(100)
#'   Co.UPM(0, x, y, mean(x), mean(y))
#' @export
Co.UPM <- function(degree_upm, x, y, target_x, target_y) {
    .Call(`_NNS_CoUPM_RCPP`, degree_upm, x, y, target_x, target_y)
}

#' @name D.LPM
#' @title Divergent‑Lower Partial Moment
#' @description
#'   Computes the divergent lower partial moment (lower‑right quadrant 3)
#'   between two equal‑length numeric vectors.
#' @param degree_lpm numeric; LPM degree = 0 gives frequency, = 1 gives area.
#' @param degree_upm numeric; UPM degree = 0 gives frequency, = 1 gives area.
#' @param x numeric vector of observations.
#' @param y numeric vector of the same length as x.
#' @param target_x numeric vector; thresholds for x (defaults to mean(x)).
#' @param target_y numeric vector; thresholds for y (defaults to mean(y)).
#' @return Numeric vector of divergent LPM values.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @examples
#'   set.seed(123)
#'   x <- rnorm(100); y <- rnorm(100)
#'   D.LPM(0, 0, x, y, mean(x), mean(y))
#' @export
D.LPM <- function(degree_lpm, degree_upm, x, y, target_x, target_y) {
    .Call(`_NNS_DLPM_RCPP`, degree_lpm, degree_upm, x, y, target_x, target_y)
}

#' @name D.UPM
#' @title Divergent‑Upper Partial Moment
#' @description
#'   Computes the divergent upper partial moment (upper‑left quadrant 2)
#'   between two equal‑length numeric vectors.
#' @param degree_lpm numeric; LPM degree = 0 gives frequency, = 1 gives area.
#' @param degree_upm numeric; UPM degree = 0 gives frequency, = 1 gives area.
#' @param x numeric vector of observations.
#' @param y numeric vector of the same length as x.
#' @param target_x numeric vector; thresholds for x (defaults to mean(x)).
#' @param target_y numeric vector; thresholds for y (defaults to mean(y)).
#' @return Numeric vector of divergent UPM values.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @examples
#'   set.seed(123)
#'   x <- rnorm(100); y <- rnorm(100)
#'   D.UPM(0, 0, x, y, mean(x), mean(y))
#' @export
D.UPM <- function(degree_lpm, degree_upm, x, y, target_x, target_y) {
    .Call(`_NNS_DUPM_RCPP`, degree_lpm, degree_upm, x, y, target_x, target_y)
}

#' @name PM.matrix
#' @title Partial Moment Matrix
#' @description
#'   Builds a list containing all four quadrant partial‑moment matrices
#'   (CUPM, DUPM, DLPM, CLPM) plus the overall covariance matrix.
#' @param LPM_degree numeric; lower partial moment degree (0 = freq, 1 = area).
#' @param UPM_degree numeric; upper partial moment degree (0 = freq, 1 = area).
#' @param target numeric vector; thresholds for each column (defaults to colMeans).
#' @param variable numeric matrix or data.frame.
#' @param pop_adj logical; TRUE adjusts population vs. sample moments.
#' @param norm logical; \code{FALSE} (default) if TRUE, each of the four quadrant partial-moment matrices (cupm, dupm, dlpm, clpm) is normalized cell-wise so that their sum at each position is 1. The covariance matrix is then recomputed from those normalized quadrants.
#' @return A list with elements $cupm, $dupm, $dlpm, $clpm and $cov.matrix.
#' @author Fred Viole, OVVO Financial Systems
#' @references
#'   Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)
#' @examples
#'   set.seed(123)
#'   A <- cbind(rnorm(100), rnorm(100), rnorm(100))
#'   PM.matrix(1, 1, NULL, A, TRUE)
#' @export
PM.matrix <- function(LPM_degree, UPM_degree, target, variable, pop_adj, norm = FALSE) {
    .Call(`_NNS_PMMatrix_RCPP`, LPM_degree, UPM_degree, target, variable, pop_adj, norm)
}

NNS_bin <- function(x, width, origin = 0, missinglast = FALSE) {
    .Call(`_NNS_NNS_bin`, x, width, origin, missinglast)
}

