% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEAXAI_fitting.R
\name{PEAXAI_fitting}
\alias{PEAXAI_fitting}
\title{Training Classification Models to Estimate Efficiency}
\usage{
PEAXAI_fitting(
  data,
  x,
  y,
  RTS = "vrs",
  imbalance_rate = NULL,
  trControl,
  methods,
  metric_priority = "Balanced_Accuracy",
  hold_out = NULL,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} containing the variables in the model.}

\item{x}{Integer vector with column indices of input variables in \code{data}.}

\item{y}{Integer vector with column indices of output variables in \code{data}.}

\item{RTS}{Text string or number defining the underlying DEA technology /
returns-to-scale assumption (default: \code{"vrs"}). Accepted values:
\describe{
\item{\code{0} / \code{"fdh"}}{Free disposability hull, no convexity assumption.}
\item{\code{1} / \code{"vrs"}}{Variable returns to scale, convexity and free disposability.}
\item{\code{2} / \code{"drs"}}{Decreasing returns to scale, convexity, down-scaling and free disposability.}
\item{\code{3} / \code{"crs"}}{Constant returns to scale, convexity and free disposability.}
\item{\code{4} / \code{"irs"}}{Increasing returns to scale (up-scaling, not down-scaling), convexity and free disposability.}
\item{\code{5} / \code{"add"}}{Additivity (scaling up and down, but only with integers), and free disposability.}
}}

\item{imbalance_rate}{Optional target(s) for class balance via SMOTE. If \code{NULL},
no synthetic balancing is performed.}

\item{trControl}{A \code{caret::trainControl}-like list that specifies the resampling
strategy; recognized values for \code{$method} include \code{"cv"}, \code{"test_set"},
and \code{"none"}. See \pkg{caret} documentation.}

\item{methods}{A \code{list} of selected machine learning models and their hyperparameters.}

\item{metric_priority}{A \code{string} specifying the summary metric for classification to select the optimal model. Default includes \code{"Balanced_Accuracy"} due to (normally) unbalanced data.}

\item{hold_out}{Numeric proportion in (0,1) for validation split (default \code{NULL}).
If \code{NULL}, training and validation use the same data.}

\item{seed}{Integer. Seed for reproducibility.}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages (default \code{FALSE}).}
}
\value{
A \code{"PEAXAI"} (list) with the best technique, best fitted models and their performance and the results by fold.
}
\description{
Trains one or multiple classification algorithms to identify Pareto-efficient
decision-making units (DMUs). It jointly searches model hyperparameters and the
class-balancing level (synthetic samples via SMOTE) using k-fold cross-
validation or a train/validation/test split, selecting the configuration that
maximizes the specified metric(s). Returns, for each technique, the best fitted
model together with training summaries, performance metrics, and the selected
balancing level.
}
\examples{
\donttest{
  data("firms", package = "PEAXAI")

  data <- subset(
    firms,
    autonomous_community == "Comunidad Valenciana"
  )

  trControl <- list(
    method = "cv",
    number = 3
  )

  # glm method
  methods <- list(
    "glm" = list(
        weights = "dinamic"
     )
  )

  models <- PEAXAI_fitting(
    data = data,
    x = c(1:4),
    y = 5,
    RTS = "vrs",
    imbalance_rate = NULL,
    methods = methods,
    trControl = trControl,
    metric_priority = c("Balanced_Accuracy", "ROC_AUC"),
    seed = 1,
    verbose = FALSE
  )
}

}
