% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspacePlots.R
\docType{methods}
\name{plotPathwaySpace,PathwaySpace-method}
\alias{plotPathwaySpace,PathwaySpace-method}
\alias{plotPathwaySpace}
\title{Plotting 2D-landscape images for the PathwaySpace package}
\usage{
\S4method{plotPathwaySpace}{PathwaySpace}(
  ps,
  colors = pspace.cols(),
  trim.colors = c(3, 2, 1, 2, 3),
  bg.color = "grey95",
  si.color = "grey85",
  si.alpha = 1,
  theme = c("th0", "th1", "th2", "th3"),
  title = "PathwaySpace",
  xlab = "Pathway coordinates 1",
  ylab = "Pathway coordinates 2",
  zlab = "Density",
  font.size = 1,
  font.color = "white",
  zlim = NULL,
  slices = 25,
  add.grid = TRUE,
  grid.color = "white",
  add.summits = TRUE,
  label.summits = TRUE,
  summit.color = "white",
  add.marks = FALSE,
  marks = NULL,
  mark.size = 3,
  mark.color = "white",
  mark.padding = 0.5,
  mark.line.width = 0.5,
  use.dotmark = FALSE,
  add.image = FALSE
)
}
\arguments{
\item{ps}{A \linkS4class{PathwaySpace} class object.}

\item{colors}{A vector of colors. Each color is a specific hue used to 
create a customized color palette, interpolated according to the provided 
sequence in the vector of colors. The proportion of each color hue can be 
adjusted by the 'trim.colors' argument. This palette is designed to 
fine-tune the visibility of summits and valleys within the image space.
To bypass this automatic palette generation and use the 'colors' 
input as-is, simply set 'trim.colors' to NULL.}

\item{trim.colors}{An vector with 5 positive integer numbers. This argument
can be used to adjust the proportion of each color hue in the palette.}

\item{bg.color}{A single color for background.}

\item{si.color}{A single color for silhouette.
(see \code{\link{silhouetteMapping}}).}

\item{si.alpha}{A transparency level in [0, 1], used to adjust the 
opacity of the silhouette. This parameter is useful for improving the 
perception of a background image, when one is available.}

\item{theme}{Name of a custom PathwaySpace theme. These themes 
(from 'th0' to 'th3') consist mainly of preconfigured ggplot settings, 
which the user can subsequently refine using \code{\link[ggplot2]{ggplot2}}.}

\item{title}{A string for the title.}

\item{xlab}{The title for the 'x' axis of a 2D-image space.}

\item{ylab}{The title for the 'y' axis of a 2D-image space.}

\item{zlab}{The title for the 'z' axis of the image signal.}

\item{font.size}{A single numeric value passed to ggplot themes.}

\item{font.color}{A single color passed to ggplot themes.}

\item{zlim}{The 'z' limits of the plot (a numeric vector with two numbers).
If NULL, limits are determined from the range of the input values.}

\item{slices}{A single positive integer value used to split 
the image signal into equally-spaced intervals.}

\item{add.grid}{A logical value indicating whether to add gridlines to 
the image space. However, gridlines will only appear when the image 
is decorated with graph silhouettes (see \code{\link{silhouetteMapping}}).}

\item{grid.color}{A color passed to \code{\link[ggplot2]{geom_point}}.}

\item{add.summits}{A logical value indicating whether to add contour 
lines to 'summits' (when summits are available; 
see \code{\link{summitMapping}}).}

\item{label.summits}{A logical value indicating whether to label summits.}

\item{summit.color}{A color passed to 'summits'.}

\item{add.marks}{A logical value indicating whether to plot vertex labels.}

\item{marks}{A vector of vertex names to be highlighted in the 
image space. This argument overrides 'add.labels'.}

\item{mark.size}{A size argument passed to \code{\link[ggplot2]{geom_text}}.}

\item{mark.color}{A color passed to \code{\link[ggplot2]{geom_text}}.}

\item{mark.padding}{A box padding argument passed to 
\code{\link[ggrepel]{geom_text_repel}}.}

\item{mark.line.width}{A line width argument passed to 
\code{\link[ggrepel]{geom_text_repel}}.}

\item{use.dotmark}{A logical value indicating whether "marks" should be 
represented as dots.}

\item{add.image}{A logical value indicating whether to add a background 
image, when one is available (see \code{\link[RGraphSpace]{GraphSpace}}).}
}
\value{
A ggplot-class object.
}
\description{
\code{plotPathwaySpace} is a wrapper function to 
create dedicated ggplot graphics for PathwaySpace-class objects.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# # Check graph validity
gs <- GraphSpace(gtoy1)

# Create a PathwaySpace object
ps <- buildPathwaySpace(gs, nrc = 300)
# note: adjust 'nrc' to increase image resolution

# Set '1s' as vertex signal
vertexSignal(ps) <- 1

# Create a 2D-landscape image
ps <- circularProjection(ps, k = 2, pdist = 0.4)

# Plot a 2D-landscape image
plotPathwaySpace(ps)

}
\seealso{
\code{\link{circularProjection}}
}
\author{
Mauro Castro and TCGA Network.
}
