% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uploadToDatabase.R
\name{createDatabaseSchemaSettings}
\alias{createDatabaseSchemaSettings}
\title{Create the PatientLevelPrediction database result schema settings}
\usage{
createDatabaseSchemaSettings(
  resultSchema = "main",
  tablePrefix = "",
  targetDialect = "sqlite",
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDefinitionSchema = resultSchema,
  tablePrefixCohortDefinitionTables = tablePrefix,
  databaseDefinitionSchema = resultSchema,
  tablePrefixDatabaseDefinitionTables = tablePrefix
)
}
\arguments{
\item{resultSchema}{(string) The name of the database schema with the result tables.}

\item{tablePrefix}{(string) A string that appends to the PatientLevelPrediction result tables}

\item{targetDialect}{(string) The database management system being used}

\item{tempEmulationSchema}{(string) The temp schema used when the database management system is oracle}

\item{cohortDefinitionSchema}{(string) The name of the database schema with the cohort definition tables (defaults to resultSchema).}

\item{tablePrefixCohortDefinitionTables}{(string) A string that appends to the cohort definition tables}

\item{databaseDefinitionSchema}{(string) The name of the database schema with the database definition tables (defaults to resultSchema).}

\item{tablePrefixDatabaseDefinitionTables}{(string) A string that appends to the database definition tables}
}
\value{
Returns a list of class 'plpDatabaseResultSchema' with all the database settings
}
\description{
This function specifies where the results schema is and lets you pick a different schema for the cohorts and databases
}
\details{
This function can be used to specify the database settings used to upload PatientLevelPrediction results into a database
}
\examples{
createDatabaseSchemaSettings(resultSchema = "cdm",
                             tablePrefix = "plp_")

}
