% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureEngineering.R
\name{createUnivariateFeatureSelection}
\alias{createUnivariateFeatureSelection}
\title{Create the settings for defining any feature selection that will be done}
\usage{
createUnivariateFeatureSelection(k = 100)
}
\arguments{
\item{k}{This function returns the K features most associated
(univariately) to the outcome}
}
\value{
An object of class \code{featureEngineeringSettings}
}
\description{
Create the settings for defining any feature selection that will be done
}
\details{
Returns an object of class \code{featureEngineeringSettings} that specifies
the function that will be called and the settings. Uses the scikit-learn
SelectKBest function with chi2 for univariate feature selection.
}
\examples{
\dontshow{ # dontrun reason: requires python and scikit-learn }
\dontrun{ #' # create a feature selection that selects the 100 most associated features
featureSelector <- createUnivariateFeatureSelection(k = 100) 
}
}
