% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LightGBM.R
\name{setLightGBM}
\alias{setLightGBM}
\title{Create setting for gradient boosting machine model using lightGBM
(https://github.com/microsoft/LightGBM/tree/master/R-package).}
\usage{
setLightGBM(
  nthread = 20,
  earlyStopRound = 25,
  numIterations = c(100),
  numLeaves = c(31),
  maxDepth = c(5, 10),
  minDataInLeaf = c(20),
  learningRate = c(0.05, 0.1, 0.3),
  lambdaL1 = c(0),
  lambdaL2 = c(0),
  scalePosWeight = 1,
  isUnbalance = FALSE,
  seed = sample(1e+07, 1)
)
}
\arguments{
\item{nthread}{The number of computer threads to use (how many cores do you have?)}

\item{earlyStopRound}{If the performance does not increase over earlyStopRound number of trees then training stops (this prevents overfitting)}

\item{numIterations}{Number of boosting iterations.}

\item{numLeaves}{This hyperparameter sets the maximum number of leaves. Increasing this parameter can lead to higher model complexity and potential overfitting.}

\item{maxDepth}{This hyperparameter sets the maximum depth . Increasing this parameter can also lead to higher model complexity and potential overfitting.}

\item{minDataInLeaf}{This hyperparameter sets the minimum number of data points that must be present in a leaf node. Increasing this parameter can help to reduce overfitting}

\item{learningRate}{This hyperparameter controls the step size at each iteration of the gradient descent algorithm. Lower values can lead to slower convergence but may result in better performance.}

\item{lambdaL1}{This hyperparameter controls L1 regularization, which can help to reduce overfitting by encouraging sparse models.}

\item{lambdaL2}{This hyperparameter controls L2 regularization, which can also help to reduce overfitting by discouraging large weights in the model.}

\item{scalePosWeight}{Controls weight of positive class in loss - useful for imbalanced classes}

\item{isUnbalance}{This parameter cannot be used at the same time with scalePosWeight, choose only one of them. While enabling this should increase the overall performance metric of your model, it will also result in poor estimates of the individual class probabilities.}

\item{seed}{An option to add a seed when training the final model}
}
\value{
A list of settings that can be used to train a model with \code{runPlp}
}
\description{
Create setting for gradient boosting machine model using lightGBM
(https://github.com/microsoft/LightGBM/tree/master/R-package).
}
\examples{
\dontshow{if (rlang::is_installed("lightgbm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
modelLightGbm <- setLightGBM(
  numLeaves = c(20, 31, 50), maxDepth = c(-1, 5, 10),
  minDataInLeaf = c(10, 20, 30), learningRate = c(0.05, 0.1, 0.3)
)
\dontshow{\}) # examplesIf}
}
