% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SklearnClassifierSettings.R
\name{setSVM}
\alias{setSVM}
\title{Create setting for the python sklearn SVM (SVC function)}
\usage{
setSVM(
  C = list(1, 0.9, 2, 0.1),
  kernel = list("rbf"),
  degree = list(1, 3, 5),
  gamma = list("scale", 1e-04, 3e-05, 0.001, 0.01, 0.25),
  coef0 = list(0),
  shrinking = list(TRUE),
  tol = list(0.001),
  classWeight = list(NULL),
  cacheSize = 500,
  seed = sample(1e+05, 1)
)
}
\arguments{
\item{C}{(list) Regularization parameter. The strength of the regularization is inversely proportional to C. Must be strictly positive. The penalty is a squared l2 penalty.}

\item{kernel}{(list) Specifies the kernel type to be used in the algorithm. one of ‘linear’, ‘poly’, ‘rbf’, ‘sigmoid’, ‘precomputed’. If none is given ‘rbf’ will be used.}

\item{degree}{(list) degree of kernel function is significant only in poly, rbf, sigmoid}

\item{gamma}{(list) kernel coefficient for rbf and poly, by default 1/n_features will be taken. ‘scale’, ‘auto’ or float, default=’scale’}

\item{coef0}{(list) independent term in kernel function. It is only significant in poly/sigmoid.}

\item{shrinking}{(list) whether to use the shrinking heuristic.}

\item{tol}{(list) Tolerance for stopping criterion.}

\item{classWeight}{(list) Class weight based on imbalance either 'balanced' or NULL}

\item{cacheSize}{Specify the size of the kernel cache (in MB).}

\item{seed}{A seed for the model}
}
\value{
a modelSettings object
}
\description{
Create setting for the python sklearn SVM (SVC function)
}
\examples{
\dontshow{ # dontrun reason: requires python's scikit-learn, checkSklearn() will error without it }
\dontrun{ 
plpData <- getEunomiaPlpData()
model <- setSVM(C = list(1), gamma = list("scale"), seed = 42)
saveLoc <- file.path(tempdir(), "svm")
results <- runPlp(plpData, modelSettings = model, saveDirectory = saveLoc)
# clean up
unlink(saveLoc, recursive = TRUE)
}
}
