% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E_step.R
\name{log_likelihood}
\alias{log_likelihood}
\alias{log_likelihood.PhyloEM}
\alias{log_likelihood.params_process}
\title{Log Likelihood of a fitted object}
\usage{
log_likelihood(x, ...)

\method{log_likelihood}{params_process}(x, Y_data, phylo, ...)

\method{log_likelihood}{PhyloEM}(x, ...)
}
\arguments{
\item{x}{an object of class \code{\link{params_process}} or \code{\link{PhyloEM}}.}

\item{...}{for a \code{PhyloEM} object, further arguments to be passed on to
\code{\link{params_process.PhyloEM}} (to choose which parameters to extract from
the results, see documentation of this function).}

\item{Y_data}{matrix of data at the tips, size p x ntaxa. Each line is a
trait, and each column is a tip. The column names are checked against the
tip names of the tree.}

\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.
\code{\link{incidence.matrix.full}}. Can be precised to avoid extra computations.}
}
\value{
The log likelihood of the data with the provided parameters on the tree.
}
\description{
\code{log_likelihood} computes the log likelihood of some parameters.
}
\section{Methods (by class)}{
\itemize{
\item \code{params_process}: \code{\link{params_process}} object

\item \code{PhyloEM}: \code{\link{PhyloEM}} object
}}
\seealso{
\code{\link{params_process}}, \code{\link{PhyloEM}}
}

