% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitionsNumber.R
\name{sum.simplex}
\alias{sum.simplex}
\title{Sum on a simplex}
\usage{
\method{sum}{simplex}(NN, K, p)
}
\arguments{
\item{NN}{a matrix with p rows and K column. Each row contains the number of
partition in 1<=k<=K groups for one of the p children of a given node}

\item{K}{an integer. The number of groups wanted.}

\item{p}{an integer. The number of daughters of a node.}
}
\value{
double : the result of the sum.
}
\description{
\code{sum.simplex} returns the sum on k_1+...+k_p=K, k_i>0 of the products
of NN[i,k_i].
}
\details{
This function uses \code{xsimplex} to perform the product of NN[i,k_i] for
all combination of k_i such that k_1+...+k_p=K, k_i>0, using function
\code{prod.index}. Then sum all the products.
}
\keyword{internal}
