% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{parsimonyCost}
\alias{parsimonyCost}
\title{Minimal number of shifts needed to get a clustering.}
\usage{
parsimonyCost(phylo, clusters = rep(1, length(phylo$tip.label)))
}
\arguments{
\item{phylo}{a phylogenetic tree, class \code{\link[ape]{phylo}}.}

\item{clusters}{the vector of the clusters of the tips. (Default to all the tips
in a single group).}
}
\value{
An S3 class "\code{parsimonyCost}" containing a 
(ntaxa + nNodes) x (nclus) matrix of the total number of shifts needed to
get the clustering, if starting from a node in state k. The cost can be
extract from any subtree with function \code{\link{extract.parsimonyCost}}.
}
\description{
\code{parsimonyCost} is an implementation of the Sankoff algorithm,
when the cost of transition between two state is always one. It is used
in functions \code{\link{parsimonyNumber}} and \code{\link{enumerate_parsimony}}
to count or enumerate all the parsimonious solutions given one clustering of the
tips.
}
\examples{
tree <- read.tree(text="(((1,1),2),2);")
plot(tree); nodelabels()
clusters <- c(1, 1, 2, 2)
costs <- parsimonyCost(tree, clusters)
costs

## Extract the parsimony cost at the root
extract(costs)

## Extract the cost for the sub-tree below node 7
extract(costs, 7)

}
\seealso{
\code{\link{extract.parsimonyCost}}, \code{\link{parsimonyNumber}}, 
\code{\link{enumerate_parsimony}}, \code{\link{partitionsNumber}},
\code{\link{equivalent_shifts}}
}
