% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mult.portfolio.spec}
\alias{mult.portfolio.spec}
\title{Multple Layer Portfolio Specification}
\usage{
mult.portfolio.spec(portfolio, levels = 2, ...)
}
\arguments{
\item{portfolio}{the "top level" portfolio}

\item{levels}{number of levels of sub-portfolios}

\item{\dots}{any additional parameters}
}
\value{
a \code{mult.portfolio.spec} object with the top level portfolio
and sub portfolios with optimization parameters for each sub portfolio
}
\description{
Create and specify a multiple layer portfolio
}
\details{
The \code{sub.portfolios} slot is a list where each element contains the
portfolio object and rebalancing parameters for the optimization of the
sub portfolio.
This allows, for example, each sub portfolio to have different rebalancing
frequencies (i.e. monthly or quarterly), optimization methods, etc.

Each sub portfolio is optimized with \code{optimize.portfolio.rebalancing}
to create a time series of proxy returns.

The "top level" portfolio is used to specify the constraints and objectives
to control the optimization given the proxy returns of each sub portfolio.
}
\author{
Ross Bennett
}

