% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objective.R
\name{minmax_objective}
\alias{minmax_objective}
\title{constructor for class tmp_minmax_objective}
\usage{
minmax_objective(
  name,
  target = NULL,
  arguments = NULL,
  multiplier = 1,
  enabled = TRUE,
  ...,
  min,
  max
)
}
\arguments{
\item{name}{name of the objective, should correspond to a function, though we will try to make allowances}

\item{target}{univariate target for the objective}

\item{arguments}{default arguments to be passed to an objective function when executed}

\item{multiplier}{multiplier to apply to the objective, usually 1 or -1}

\item{enabled}{TRUE/FALSE}

\item{\dots}{any other passthru parameters}

\item{min}{minimum value}

\item{max}{maximum value}
}
\value{
object of class 'minmax_objective'
}
\description{
This objective allows for min and max targets to be specified.
}
\details{
If target is set, we'll try to meet the metric

If target is NULL and min and max are specified, then do the following:

If max is violated to the upside, penalize the metric. If min is violated to 
the downside, penalize the metric. The purpose of this objective is to try
to meet the range between min and max
}
\author{
Ross Bennett
}
