% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_rank}
\alias{weight_by_rank}
\title{Rank-Based Portfolio Weighting}
\usage{
weight_by_rank(
  selected_df,
  signal_df,
  method = c("linear", "exponential"),
  ascending = FALSE
)
}
\arguments{
\item{selected_df}{Binary selection matrix}

\item{signal_df}{Signal values for ranking}

\item{method}{Weighting method: "linear" or "exponential"}

\item{ascending}{Sort order for ranking (default: FALSE)}
}
\value{
Data.table with rank-based weights
}
\description{
Weights securities based on their rank rather than raw signal values.
Useful when signal magnitudes are unreliable but ordering is meaningful.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, 10)
# Linear rank weighting (best gets most)
weights <- weight_by_rank(selected, momentum, method = "linear")
# Exponential (heavy on top stocks)
weights_exp <- weight_by_rank(selected, momentum, method = "exponential")
}
