% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_powerest.R
\name{fit_powerest}
\alias{fit_powerest}
\title{Fit the power surface}
\usage{
fit_powerest(power,avg_log2FC,avg_PCT,filter_zero=TRUE)
}
\arguments{
\item{power}{The raw power values.}

\item{avg_log2FC}{The corresponding log2FC values.}

\item{avg_PCT}{The corresponding PCT values.}

\item{filter_zero}{Whether the user would like to filter to remove the power values being 0, default=TRUE.}
}
\value{
A 'scam' object is the result of scam function. More information about the content of a 'scam' object can be found
at the document of R package \href{https://CRAN.R-project.org/package=scam}{scam}.
}
\description{
This function loads the power values with corresponding avg_log2FC and avg_PCT derived from bootstrap sampling
and utilizes the \href{https://CRAN.R-project.org/package=scam}{scam} package to fit two dimensional
smoothing splines under monotone constraints: 1.positive relationship between power and avg_log2FC;
2.positive relationship between power and avg_PCT. The values of avg_log2FC and avg_PCT can be either
from the averages of the bootstrap samples or from the original spatial transcriptomics data.
}
\examples{
data(result_example)
 \donttest{b<-fit_powerest(result_example$power,result_example$avg_logFC,result_example$avg_PCT)}
}
\author{
Lan Shui \email{lshui@mdanderson.org}
}
