\name{GeoMinMOS}
\alias{GeoMinMOS}
\title{
   Check geographic PSUs to determine whether any are less than minimum measure of size threshold
}
\description{
    Identify geographic PSUs whose measure of size is below a specified minimum and combine those PSUs with others
}
\usage{
   GeoMinMOS(lat, long, geo.var, MOS.var, MOS.min)
}
\arguments{
   \item{lat}{latitude variable in an input file. Must be in decimal format.}
   \item{long}{longitude variable in an input file. Must be in decimal format.}
   \item{geo.var}{Geographic variable ID for grouping}
   \item{MOS.var}{Measure of size (MOS) for each PSU}
   \item{MOS.min}{Minimum allowed MOS value}
}
\details{
\code{GeoMinMOS} is a utility function that should be run after using \code{GeoDistMOS} or \code{GeoDistPSU}. \code{GeoMinMOS} identifies each PSU whose measure of size, (MOS.var), is below the minimum specified by \code{MOS.min}. Distances to the latitude/longitude centroids of other PSUs are calculated. The undersized PSUs are then combined with the nearest PSUs in proximity order until the minimum MOS is met or exceeded. In some cases, \emph{this can result in the same input PSU being assigned to more than one combined PSU}. Also, the distances between the centroids of the PSUs in a combination may be impractically large. Thus, the new combinations generated by \code{GeoMinMOS} should be treated as suggestions that should be manually reviewed and adjusted if desired.
}

\value{
  A list with four components:
     \item{Parameter.Information}{A data frame with three elements: \code{Minimum.MOS} = value of \code{MOS.min}; \code{Geo.vars.start} = total number of PSUs in the input data set; \code{Geo.Vars.lt.min.MOS} = number of PSUs whose MOS was less than the minimum.
        }
     \item{Input.Information}{A data frame containing \code{Geo.Var} = geographic variable ID in the input data set used for grouping; \code{Geo.MOS} = MOS of each PSU in the input data set; \code{Below.min.MOS} = TRUE/FALSE indicator for whether a PSU's MOS was below the minimum in \code{MOS.min}.
        }
     \item{Geo.var.MOS.output}{A data frame with PSUs that were formed by combining undersized PSUs with adequately-sized PSUs. Columns in the data frame are: \code{Geo.Var} = new geographic variable ID for a combined PSU. This is equal to \code{geo.var} for the undersized PSU used in a combination;  \code{New.Geo.MOS} = input MOS for each PSU; \code{Geo.Cum.MOS} = cumulative MOS for a combined PSU. The last PSU in a combination will have the total size of the combined PSU; \code{Geo.Var.ID} = geographic variable ID for a PSU in the input data set;  \code{Geo.Var.Num} = sequential number (1, 2, etc.) for the PSUs in a combination; \code{Geo.Var.Kms} = distance in kilometers of a PSU's centroid to the centroid of the undersized PSU in a combination. The undersized PSU will have a distance of 0; \code{Geo.Var.Miles} = distance in miles of a PSU's centroid to the centroid of the undersized PSU in a combination. The undersized PSU will have a distance of 0; \code{Geo.Var.Lat} = latitude of the PSU centroid; \code{Geo.Var.Long} = longitude of the PSU centroid.
         }
     \item{For.Review}{A list of the \code{geo.var}'s of PSUs that are used in more than one combination; these should be manually reviewed to determine which combination is preferred. The distances between PSU centroids in \code{Geo.var.MOS.output} can be helpful in the review.
         }
}

\author{
George Zipf, Richard Valliant
}
\seealso{
\code{\link{GeoDistPSU}}, \code{\link{GeoDistMOS}}
}
\examples{
library(PracTools)
library(dplyr)
g <- GeoDistPSU(Test_Data_US$lat,
                Test_Data_US$long,
                "miles",
                100,
                Input.ID = Test_Data_US$ID)
Test_Data_US <- inner_join(Test_Data_US, g$PSU.ID, by=c("ID" = "Input.file.ID"))
GeoMinMOS(lat      = Test_Data_US$lat,
          long     = Test_Data_US$long,
          geo.var  = Test_Data_US$psuID,
          MOS.var  = Test_Data_US$Amount,
          MOS.min  = 200000)
}

\keyword{methods}
\keyword{survey}

