% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_new.R
\name{dissimilarity}
\alias{dissimilarity}
\title{Calculating the relative price and/or quantity dissimilarity measure between periods}
\usage{
dissimilarity(data, period1, period2, type = "p")
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric or character).}

\item{period1}{The first period (as character) limited to the year and month, e.g. '2019-03'.}

\item{period2}{The second period (as character) limited to the year and month, e.g. '2019-04'.}

\item{type}{The parameter indicates what type of dissimilarity measure is to be calculated. Possible values of the \code{type} parameter are: \code{p} (for the price dissimilarity measure calculation), \code{q} (for the quantity dissimilarity measure calculation) or \code{pq} (for the dSPQ measure calculation, i.e. the measure of relative price and quantity dissimilarity - see \code{References}).}
}
\value{
This function returns a value of the relative price (dSP) and/or quantity (dSQ) dissimilarity measure. In a special case, when the \code{type} parameter is set to \code{pq}, the function provides the value of dSPQ measure (the relative price and quantity dissimilarity measure calculated as min(dSP,dSQ).
}
\description{
This function returns a value of the relative price and/or quantity dissimilarity measure.
}
\examples{
dissimilarity(milk, period1="2018-12",period2="2019-12",type="q")
\donttest{dissimilarity(milk, period1="2018-12",period2="2019-12",type="pq")}
}
\references{
{Diewert, E. (2020). \emph{The Chain Drift Problem and Multilateral Indexes.} Chapter 6 in: Consumer Price Index Theory (draft)}
}
