% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_all_sources.R
\name{get_all_sources}
\alias{get_all_sources}
\title{Retrieve All Sources from PubChem}
\usage{
get_all_sources(domain = "substance")
}
\arguments{
\item{domain}{A character string specifying the domain for which sources are to be retrieved.

              Possible values are:

              - `'substance'` (default)

              - `'assay'`}
}
\value{
A character vector containing the names of all sources for the specified domain.
}
\description{
This function retrieves a list of all current depositors of substances or assays from PubChem.
}
\details{
The PubChem PUG REST API provides a way to retrieve all current depositors (sources) for substances or assays.
For more detailed information, please refer to the
\href{https://pubchem.ncbi.nlm.nih.gov/sources}{PubChem Data Sources documentation}.
}
\examples{
\donttest{
get_all_sources(
  domain = 'substance'
)
}
}
