% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/csQCAbinTest.R
\name{csQCAbinTest}
\alias{csQCAbinTest}
\title{A Simple Binomial Test for Type I Error in csQCA}
\usage{
csQCAbinTest(freq.y, configs, total.configs, adj.method = "holm")
}
\arguments{
\item{freq.y}{The frequency with which the dependent variable occurs in the
sample (the number of 1s divided by the total number of cases).}

\item{configs}{A list of configurations and the number of cases in which each
configuration occurs.}

\item{total.configs}{The total number of configurations used in the original
csQCA analysis. This will generally equal the number of lines in the
truth table used for Boolean minimization.}

\item{adj.method}{The method used to calculate adjusted p-values (see
\code{\link{p.adjust}} for details).}
}
\value{
An object containing the results of the Binomial test.
}
\description{
A Binomial test for crisp-set qualitative comparative analysis (csQCA),
designed to calculate the probability of a false positive given the number of
hypotheses implicitly tested and the number of confirming cases.
}
\examples{
test <- csQCAbinTest(freq.y=0.7, configs=list(aB=5, bCD=3, Ce=2),
   total.configs=20)
summary(test)
}
\keyword{Binomial}
\keyword{adjust}
\keyword{csQCA}
\keyword{inference}
\keyword{multiple}
\keyword{p-value}

