% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MA.estimates.R
\name{MA.estimates}
\alias{MA.estimates}
\title{MA Estimates}
\usage{
MA.estimates(rds.data, trait.variable, seed.selection = "degree",
  number.of.seeds = NULL, number.of.coupons = NULL,
  number.of.iterations = 3, N = NULL, M1 = 25, M2 = 20, seed = 1,
  initial.sampling.probabilities = NULL, MPLE.samplesize = 50000,
  SAN.maxit = 5, SAN.nsteps = 2^19, sim.interval = 10000,
  number.of.cross.ties = NULL, max.degree = NULL, parallel = 1,
  parallel.type = snow::getClusterOption("type"), full.output = FALSE,
  verbose = TRUE)
}
\arguments{
\item{rds.data}{An \code{rds.data.frame} that indicates recruitment patterns
by a pair of attributes named ``id'' and ``recruiter.id''.}

\item{trait.variable}{A string giving the name of the variable in the
\code{rds.data} that contains a categorical or numeric variable to be
analyzed.}

\item{seed.selection}{An estimate of the mechanism guiding the choice of
seeds.  The choices are \describe{ \item{"allwithtrait"}{indicating that all
the seeds had the trait;} \item{"random"}{meaning they were, as if, a simple
random sample of individuals from the population;}
\item{"sample"}{indicating that the seeds are taken as those in the sample
(and resampled for the population with that composition if necessary);}
\item{"degree"}{is proportional to the degree of the individual;}
\item{"allwithtraitdegree"}{indicating that all the seeds had the trait and
the probability of being a seed is proportional to the degree of the
respondent.} }}

\item{number.of.seeds}{The number of seeds chosen to initiate the sampling.}

\item{number.of.coupons}{The number of coupons given to each respondent.}

\item{number.of.iterations}{The number of iterations used at the core of the
algorithm.}

\item{N}{An estimate of the number of members of the population being
sampled. If \code{NULL} it is read as the \code{pop.size.mid} attribute of
the \code{rds.data} frame. If that is missing it defaults to 1000.}

\item{M1}{The number of networked populations generated at each iteration.}

\item{M2}{The number of (full) RDS samples generated for each networked
population at each iteration.}

\item{seed}{The random number seed used to initiate the computations.}

\item{initial.sampling.probabilities}{Initialize sampling probabilities for
the algorithm. If missing, they are taken as proportional to degree, and
this is almost always the best starting values.}

\item{MPLE.samplesize}{Number of samples to take in the computation of the
maximum pseudolikelihood estimator (MPLE) of the working model parameter.
The default is almost always sufficient.}

\item{SAN.maxit}{A ceiling on the number of simulated annealing iterations.}

\item{SAN.nsteps}{Number of MCMC proposals for all the annealing runs combined.}

\item{sim.interval}{Number of MCMC steps between each of the M1 sampled
networks per iteration.}

\item{number.of.cross.ties}{The expected number of ties between those with
the trait and those without. If missing, it is computed based on the
respondent's reports of the number of ties they have to population members
who have the trait (i.e. \code{ties.to.trait.variable}) and do not have the
trait (i.e. \code{ties.not.to.trait.variable}).}

\item{max.degree}{Impose ceiling on degree size.}

\item{parallel}{Number of processors to use in the computations. The default
is 1, that is no parallel processing.}

\item{parallel.type}{The type of cluster to start. e.g. 'sock', 'MPI', etc.}

\item{full.output}{More verbose output}

\item{verbose}{Should verbose diagnostics be printed while the algorithm is
running.}
}
\value{
If \code{trait.variable} is numeric then the model-assisted estimate
of the mean is returned, otherwise a vector of proportion estimates is
returned. If \code{full.output=TRUE} this leads to:

If \code{full.output=FALSE} this leads to an object of class
\code{rds.interval.estimate} which is a list with components \itemize{
\item{estimate}{the numerical point estimate of proportion of
the\code{trait.variable}. } \item{interval}{a matrix with size columns and one
row per category of \code{trait.variable}:\itemize{ \item{point estimate}{ The
HT estimate of the population mean.}  \item{95\% Lower Bound}{Lower 95\%
confidence bound} \item{95\% Upper Bound}{Upper 95\% confidence bound}}
\item{Design Effect}{The design effect of the RDS} \item{s.e.}{standard error}
\item{n}{count of the number of sample values with that value of the trait} } }
  rds.data An \code{rds.data.frame} that indicates recruitment
patterns by a pair of attributes named ``id'' and ``recruiter.id''.
  N An estimate of the number of members of the population being
sampled. If \code{NULL} it is read as the \code{pop.size.mid} attribute of
the \code{rds.data} frame. If that is missing it defaults to 1000.
  M1 The number of networked populations generated at each
iteration.
  M2 The number of (full) RDS populations generated for each
networked population at each iteration.
  seed The random number seed used to initiate the computations.
  seed.selection An estimate of the mechanism guiding the choice
of seeds.  The choices are \describe{ \item{"allwithtrait"}{indicating that
all the seeds had the trait;} \item{"random"}{meaning they were, as if, a
simple random sample of individuals from the population;}
\item{"sample"}{indicating that the seeds are taken as those in the sample
(and resampled for the population with that composition if necessary);}
\item{"degree"}{is proportional to the degree of the individual;}
\item{"allwithtraitdegree"}{indicating that all the seeds had the trait and
the probability of being a seed is proportional to the degree of the
respondent.} }
  number.of.seeds The number of seeds chosen to initiate the
sampling.
  number.of.coupons The number of coupons given to each
respondent.
  number.of.iterations The number of iterations used at the core
of the algorithm.
  outcome.variable The name of the outcome variable
  weight.type The type of weighting used (i.e. MA)
  uncertainty The type of weighting used (i.e. MA)
  details A list of other diagnostic output from the computations.
  varestBS Output from the bootstrap procedure. A list with two
elements: \code{var} is the bootstrap variance, and \code{BSest} is the
vector of bootstrap estimates themselves.
  coefficient estimate of the parameter of the ERGM for the
network.
}
\description{
This function computes the sequential sampling (MA) estimates for a
categorical variable or numeric variable.
}
\examples{

\dontrun{
data(faux)
MA.estimates(rds.data=faux,trait.variable='X')
}

}
\references{
Gile, Krista J. 2011 Improved Inference for
Respondent-Driven Sampling Data with Application to HIV Prevalence
Estimation, Journal of the American Statistical Association, 106,
135-146.

Gile, Krista J., Handcock, Mark S., 2010. Respondent-driven Sampling:
An Assessment of Current Methodology, Sociological Methodology, 40,
285-327.

%Gile, Krista J., Handcock, Mark S., 2011 Network Model-Assisted
%Inference from Respondent-Driven Sampling Data, ArXiv Preprint.

%%Neely, W. W., 2009. \emph{Bayesian methods for data from respondent driven
%sampling}. Dissertation in-progress, Department of Statistics, University of
%Wisconsin, Madison.

%Salganik, M., Heckathorn, D. D., 2004. Sampling and estimation in
%hidden populations using respondent-driven sampling. Sociological
%Methodology 34, 193-239.

%Volz, E., Heckathorn, D., 2008. Probability based estimation theory
%for Respondent Driven Sampling. The Journal of Official Statistics 24 (1),
%79-97.
}
\seealso{
\itemize{
\item{RDS.I.estimates}{\code{\link{RDS.I.estimates}}}
\item{RDS.II.estimates}{\code{\link{RDS.I.estimates}}}}
}
\author{
Krista J. Gile with help from Mark S. Handcock
}
\keyword{manip}
\keyword{survey}
