% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MA.sampling-c.R
\name{rdssampleC}
\alias{rdssampleC}
\title{Create RDS samples with given characteristics}
\usage{
rdssampleC(
  net,
  nnodes = network.size(net),
  nsamp0,
  fixinitial,
  nsamp,
  replace,
  coupons,
  select = NULL,
  bias = NULL,
  rds.samp = NULL,
  seed.distribution = NULL,
  attrall = FALSE,
  trait.variable = "disease",
  nsims = 1,
  seeds = NULL,
  prob.network.recall = 1,
  verbose = TRUE
)
}
\arguments{
\item{net}{the network object from which to draw a sample}

\item{nnodes}{the number of nodes in the network [at least as default]}

\item{nsamp0}{the number of seeds to be drawn (i.e. the size of the 0th wave of sampling)}

\item{fixinitial}{a variable that indicates the distribution from which to draw the initial seeds, if the seeds
variable is NULL and the seed.distribution variable is NULL}

\item{nsamp}{number of individuals in each RDS sample}

\item{replace}{sampling with replacement}

\item{coupons}{number of coupons}

\item{select}{not used}

\item{bias}{not used}

\item{rds.samp}{not used}

\item{seed.distribution}{a variable [what kind?] that indicates the distribution from which to draw the initial seeds}

\item{attrall}{Whether all the information about the sample should be returned [??]}

\item{trait.variable}{attribute of interest}

\item{nsims}{number of RDS samples to draw}

\item{seeds}{an array of seeds. Default is NULL, in which case the function draws the seeds from the nodes of the network.}

\item{prob.network.recall}{simulates the probability that an individual will remember any particular link}

\item{verbose}{Print verbose output}
}
\value{
A list with the following elements:
nsample: vector of indices of sampled nodes
wsample: vector of waves of each sampled node
degsample: vector of degrees of sampled nodes
attrsample: vector of attrs of sampled nodes
toattr: vector of numbers of referrals to attrsd nodes
tonoattr: vector of number of referrans to unattrsd
nominators: recruiter of each sample
}
\description{
Create RDS samples with given characteristics
}
